package com.liquidnet.service.account.wallet.dto;

import com.liquidnet.service.account.wallet.dto.base.WalletCallParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * WalletEditParam.class
 *
 * @author zhanggb
 * Created by IntelliJ IDEA at 2020/10/21
 */
@ApiModel(value = "WalletEditParam", description = "Parameters of wallet edit")
public class WalletEditParam extends WalletCallParam {
    private static final long serialVersionUID = -169268080009201705L;
    @ApiModelProperty(position = 11, required = true, value = "Wallet number [11]")
    private String walletNo;
    @ApiModelProperty(position = 12, required = false, value = "Wallet status [5]")
    private Integer status;
    @ApiModelProperty(position = 13, required = false, value = "Wallet alias [100]")
    private String alias;
    @ApiModelProperty(position = 14, required = false, value = "Wallet operator [64]")
    private String operator;

    public String getWalletNo() {
        return walletNo;
    }

    public void setWalletNo(String walletNo) {
        this.walletNo = walletNo;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }
}
