package com.liquidnet.service.adam.service.impl;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.adam.entity.AdamRealName;
import com.liquidnet.service.adam.service.AdamRdmService;
import com.liquidnet.service.adam.service.IAdamRealNameService;
import com.liquidnet.service.adam.util.QueueUtils;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/**
 * <p>
 * 实名信息 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-10
 */
@Slf4j
@Service
public class AdamRealNameServiceImpl implements IAdamRealNameService {
    @Autowired
    private AdamRdmService adamRdmService;
    @Autowired
    private QueueUtils queueUtils;

    @Override
//    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void add(AdamRealName realName) {
        List<Object> paramList = Arrays.asList(
                realName.getRealNameId(),
                realName.getUid(),
                realName.getType(),
                realName.getNode(),
                realName.getName(),
                realName.getIdCard(),
                realName.getState(),
                realName.getCreatedAt()
        );

        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> initUserRealInfoObjs = CollectionUtil.linkedListObjectArr(),
                updateUserMobileLocateObjs = CollectionUtil.linkedListObjectArr();

        toMqSqls.add(SqlMapping.get("adam_real_name.add"));
        initUserRealInfoObjs.add(paramList.toArray());

        String mobile = (String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_MOBILE);
        String[] mobileLocateArr = adamRdmService.getMobileLocateArr(mobile);
        toMqSqls.add(SqlMapping.get("adam_user_mobile_locate.real_name"));
        if (null != mobileLocateArr && mobileLocateArr.length > 0) {
            updateUserMobileLocateObjs.add(new Object[]{
                    realName.getName(), realName.getIdCard(), realName.getCreatedAt(), realName.getUid()
            });
        }

        long s = System.currentTimeMillis();
//        queueUtils.sendMsgByRedis(
//                MQConst.AdamQueue.SQL_UCENTER.getKey(),
//                SqlMapping.get("adam_real_name.add", paramList.toArray())
//        );
        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.gets(toMqSqls, initUserRealInfoObjs, updateUserMobileLocateObjs)
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }

    @Override
    public void upsert(AdamRealName realName, boolean updateFlg) {
        List<Object> paramList = Arrays.asList(
                realName.getRealNameId(),
                realName.getUid(),
                realName.getType(),
                realName.getNode(),
                realName.getName(),
                realName.getIdCard(),
                realName.getState(),
                realName.getCreatedAt()
        );

        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> initUserRealInfoObjs = CollectionUtil.linkedListObjectArr(),
                delUserRealInfoObjs = CollectionUtil.linkedListObjectArr(),
                updateUserMobileLocateObjs = CollectionUtil.linkedListObjectArr();

        toMqSqls.add(SqlMapping.get("adam_real_name.del"));
        if (updateFlg) {
            delUserRealInfoObjs.add(new Object[]{realName.getCreatedAt(), realName.getUid()});
        }
        toMqSqls.add(SqlMapping.get("adam_real_name.add"));
        initUserRealInfoObjs.add(paramList.toArray());

        String mobile = (String) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_MOBILE);
        String[] mobileLocateArr = adamRdmService.getMobileLocateArr(mobile);
        toMqSqls.add(SqlMapping.get("adam_user_mobile_locate.real_name"));
        if (null != mobileLocateArr && mobileLocateArr.length > 0) {
            updateUserMobileLocateObjs.add(new Object[]{
                    realName.getName(), realName.getIdCard(), realName.getCreatedAt(), realName.getUid()
            });
        }

        long s = System.currentTimeMillis();
//        queueUtils.sendMsgByRedis(
//                MQConst.AdamQueue.SQL_UCENTER.getKey(),
//                SqlMapping.get("adam_real_name.add", paramList.toArray())
//        );
        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.gets(toMqSqls, delUserRealInfoObjs, initUserRealInfoObjs, updateUserMobileLocateObjs)
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }

    @Override
    public void update(AdamRealName realName, String mobile) {
        List<Object> paramList = Arrays.asList(
                realName.getRealNameId(),
                realName.getUid(),
                realName.getType(),
                realName.getNode(),
                realName.getName(),
                realName.getIdCard(),
                realName.getState(),
                realName.getCreatedAt()
        );

        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> initUserRealInfoObjs = CollectionUtil.linkedListObjectArr(),
                delUserRealInfoObjs = CollectionUtil.linkedListObjectArr(),
                updateUserMobileLocateObjs = CollectionUtil.linkedListObjectArr();

        toMqSqls.add(SqlMapping.get("adam_real_name.del_by_nft"));
        delUserRealInfoObjs.add(new Object[]{realName.getCreatedAt(), realName.getUid()});
        toMqSqls.add(SqlMapping.get("adam_real_name.add"));
        initUserRealInfoObjs.add(paramList.toArray());

        String[] mobileLocateArr = adamRdmService.getMobileLocateArr(mobile);
        toMqSqls.add(SqlMapping.get("adam_user_mobile_locate.real_name"));
        if (null != mobileLocateArr && mobileLocateArr.length > 0) {
            updateUserMobileLocateObjs.add(new Object[]{
                    realName.getName(), realName.getIdCard(), realName.getCreatedAt(), realName.getUid()
            });
        }

        long s = System.currentTimeMillis();
        queueUtils.sendMsgByRedis(
                MQConst.AdamQueue.SQL_UCENTER.getKey(),
                SqlMapping.gets(toMqSqls, delUserRealInfoObjs, initUserRealInfoObjs, updateUserMobileLocateObjs)
        );
        log.debug("#MQ耗时:{}ms", System.currentTimeMillis() - s);
    }
}
