package com.liquidnet.service.kylin.service.impl;

import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.SuperAccountUtils;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.kylin.dto.param.WqTempParam;
import com.liquidnet.service.kylin.dto.vo.WqTempVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.service.IKylinTempService;
import com.liquidnet.service.kylin.utils.DataUtils;
import com.liquidnet.service.kylin.utils.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;


/**
 * <p>
 * 轮播图 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-05-02
 */
@Service
@Slf4j
public class TempServiceImpl implements IKylinTempService {

    @Autowired
    DataUtils dataUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<Boolean> setWqRedis(String orderId) {
        try {
            dataUtils.setWqOrderId(orderId);
            return ResponseDto.success();
        } catch (Exception e) {
            log.error("ERROR 添加 万青订单id ", e);
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delWqRedis(String orderId) {
        try {
            dataUtils.delWqOrderId(orderId);
            return ResponseDto.success();
        } catch (Exception e) {
            log.error("ERROR 删除 万青订单id ", e);
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> insertWqTempExpress(WqTempParam param) {
        try {
            String uid = CurrentUtil.getCurrentUid();
            KylinOrderTicketVo orderTicketVo = dataUtils.getOrderTicketVo(param.getOrderId());
            if(!SuperAccountUtils.isSuperAccount(uid,orderTicketVo.getUserId())){
                return ResponseDto.failure(ErrorMapping.get("20003"));
            }
//            if (uid.equals("809406") || uid.equals("773650")) {
//            } else {
//                if (!orderTicketVo.getUserId().equals(uid)) {
//                    return ResponseDto.failure(ErrorMapping.get("20003"));
//                }
//            }

            Integer isTemp = dataUtils.getWqOrderId(param.getOrderId());
            if(isTemp == 0){
                return ResponseDto.failure(ErrorMapping.get("20003"));
            }

            LocalDateTime now = LocalDateTime.now();
            //获取用户相关
            String expressContact = param.getName();
            String expressAddress = param.getProvince() + param.getCity() + param.getCounty() + param.getAddress();
            String expressPhone = param.getPhone();
            String city = param.getCity();
            String province = param.getProvince();
            String county = param.getCounty();

            WqTempVo vo = WqTempVo.getNew();
            vo.setAddress(expressAddress);
            vo.setCity(city);
            vo.setCounty(county);
            vo.setProvince(province);
            vo.setMailNo("");
            vo.setName(expressContact);
            vo.setOrderId(param.getOrderId());
            vo.setPhone(expressPhone);
            dataUtils.setWqOrderVo(vo);

            queueUtils.sendMsgByRedis(
                    MQConst.KylinQueue.SQL_TRANSFER.getKey(),
                    SqlMapping.get("kylin_order_express_ex.insert",
                            param.getOrderId(), expressContact, expressAddress,
                            province, city, county, expressPhone, now));
        } catch (Exception e) {
            log.error("ERROR 添加 万青快递 ", e);
            return ResponseDto.failure();
        }
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<WqTempVo> getWqTempExpress(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        KylinOrderTicketVo orderTicketVo = dataUtils.getOrderTicketVo(orderId);
        if(!SuperAccountUtils.isSuperAccount(uid,orderTicketVo.getUserId())){
            return ResponseDto.failure(ErrorMapping.get("20003"));
        }
//        if (uid.equals("809406") || uid.equals("773650")) {
//        } else {
//            if (!orderTicketVo.getUserId().equals(uid)) {
//                return ResponseDto.failure(ErrorMapping.get("20003"));
//            }
//        }
        WqTempVo vo = dataUtils.getWqOrderVo(orderId);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> updateMailNo(String orderId, String mailNo) {
        try {
            LocalDateTime now = LocalDateTime.now();
            WqTempVo vo = dataUtils.getWqOrderVo(orderId);
            vo.setMailNo(mailNo);
            dataUtils.setWqOrderVo(vo);
            queueUtils.sendMsgByRedis(
                    MQConst.KylinQueue.SQL_TRANSFER.getKey(),
                    SqlMapping.get("kylin_order_express_ex.sendMail",
                            mailNo, now, orderId));
            return ResponseDto.success();
        } catch (Exception e) {
            log.error("ERROR 万青发货 ", e);
            return ResponseDto.failure();
        }
    }
}
