package com.liquidnet.service.candy.dto.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.List;

@ApiModel(value = "CandyMgtCouponRelateParam", description = "券关联配置")
public class CandyMgtCouponRelateParam {
    @NotBlank(message = "券ID不能为空")
    @ApiModelProperty(required = true, value = "券ID", example = "123456789")
    private String couponId;
    @NotNull(message = "适用范围不能为空")
    @ApiModelProperty(required = true, value = "适用范围[1-巡演]", allowableValues = "1")
    private Integer scope;
    @NotNull(message = "业务ID列表不能为空")
    @Size(min = 1, message = "业务ID列表最少选择一个")
    @ApiModelProperty(required = true, value = "业务ID", dataType = "List", example = "[\"IDIDIDIDIDIDID1\",\"IDIDIDIDIDIDID2\"]")
    private List<@NotBlank(message = "业务ID值不能为空") String> idList;

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public Integer getScope() {
        return scope;
    }

    public void setScope(Integer scope) {
        this.scope = scope;
    }

    public List<String> getIdList() {
        return idList;
    }

    public void setIdList(List<String> idList) {
        this.idList = idList;
    }
}
