package com.liquidnet.service.reconciliation.strategy.accounting;

import com.liquidnet.service.reconciliation.strategy.accounting.annotation.StrategyComparingAccountHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <jiabin.an@lightnet.io>
 * @version V1.0
 * @Description: 服务启动初始化策略容器-对账逻辑
 * @class: ComparingAccountStrategyListener
 * @Package com.liquidnet.service.reconciliation.strategy.transtype
 * @Copyright: LightNet @ Copyright (c) 2020
 * @date 2020/10/27 14:38
 */
@Component
public class ComparingAccountStrategyListener implements ApplicationListener<ContextRefreshedEvent> {

    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyComparingAccountHandler.class);
        ComparingAccountStrategyContext strategyContext = event.getApplicationContext().getBean(ComparingAccountStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyComparingAccountHandler typeHandler = bean.getClass().getAnnotation(StrategyComparingAccountHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IComparingAccountStrategy) bean);
        });
    }
}