package com.liquidnet.service.platform.service.impl.adam.sync.processor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.service.adam.dto.AdamMemberOrderDto;
import com.liquidnet.service.adam.dto.vo.AdamMemberOrderVo;
import com.liquidnet.service.adam.entity.AdamMemberOrder;
import com.liquidnet.service.adam.mapper.AdamMemberOrderMapper;
import com.liquidnet.service.platform.service.impl.adam.sync.SyncDataProcessorService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Slf4j
@Service
public class SyncMemberOrderProcessor extends SyncDataProcessorService {
    @Autowired
    AdamMemberOrderMapper memberOrderMapper;

    @Override
    public void dataProcessing(int stp) {
        Integer totalCount = memberOrderMapper.selectCount(Wrappers.lambdaQuery(AdamMemberOrder.class));
        int totalRows = null == totalCount ? 0 : totalCount, nth = 0, offset = 5000, pct = 0;
        log.info("Sync.processing.begin:{} / {},{} ~ {}", totalCount, nth, offset, pct);



        while (totalRows > 0) {
            int rows = nth * offset;
            log.info("Sync.processing.limit {},{} - begin", rows, offset);



            List<AdamMemberOrderDto> dtos = memberOrderMapper.selectMultiForMemberOrderDto(rows, offset);
            if (!CollectionUtils.isEmpty(dtos)) {
                int size = dtos.size();
                for (int i = 0; i < size; i++) {
                    AdamMemberOrderDto dto = dtos.get(i);

                    AdamMemberOrderVo vo = AdamMemberOrderVo.getNew().copy(dto);
                    //log.info("vo:{}", JsonUtils.toJson(vo));

                    dmRdmService.addMemberOrderVoByUid(dto.getUid(), dmRdmService.getMemberOrderVosByUid(dto.getUid()), vo);

                    pct++;
                }
            }



            nth++;
            totalRows -= offset;
            log.info("Sync.processing.limit {},{} - handle.counts:{}", rows, offset, pct);
        }



        log.info("Sync.processing.end:{} / {},{} ~ {}", totalCount, nth, offset, pct);
    }
}
