package com.liquidnet.service.sweet.utils;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.vo.SweetAppletUsersVo;
import com.liquidnet.service.sweet.vo.SweetWechatUsersVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class WechatUsersRedisUtils {

    @Autowired
    private RedisUtil redisUtil;

    public SweetWechatUsersVo getSweetWechatUsers(String unionId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS.concat(unionId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            SweetWechatUsersVo sweetWechatUsersVo = (SweetWechatUsersVo) obj;
            return sweetWechatUsersVo;
        }
    }
    public void setSweetWechatUsers(SweetWechatUsersVo sweetWechatUsersVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS.concat(sweetWechatUsersVo.getUnionId())
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(sweetWechatUsersVo.getType()));
        redisUtil.set(redisKey, sweetWechatUsersVo);
    }
    public void delSweetWechatUsers(String unionId, Integer type) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS.concat(unionId)
                .concat(SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_TYPE).concat(String.valueOf(type));
        redisUtil.del(redisKey);
    }

    public SweetAppletUsersVo getSweetAppletUsers(String mobile) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_PHONE.concat(mobile);
        Object obj = redisUtil.get(redisKey);
        if (null == obj) {
            return null;
        } else {
            SweetAppletUsersVo sweetAppletUsersVo = (SweetAppletUsersVo) obj;
            return sweetAppletUsersVo;
        }
    }
    public void setSweetAppletUsers(SweetAppletUsersVo sweetAppletUsersVo) {
        String redisKey = SweetConstant.REDIS_KEY_SWEET_APPLET_USERS_PHONE.concat(sweetAppletUsersVo.getPurePhoneNumber());
        String redisKey2 = SweetConstant.REDIS_KEY_SWEET_WECHAT_USERS_RELATION_UNIONID.concat(sweetAppletUsersVo.getUnionId());
        redisUtil.set(redisKey, sweetAppletUsersVo);
        redisUtil.set(redisKey2, sweetAppletUsersVo);
    }

}
