package com.liquidnet.service.candy.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import java.time.LocalDateTime;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 公有券信息
 * </p>
 *
 * @author liquidnet
 * @since 2021-08-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CandyCommonCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    private String ccouponId;

    /**
     * ~candy_mgt_coupon.mcoupon_id
     */
    private String mcouponId;

    /**
     * ~candy_coupon.coupon_id
     */
    private String couponId;

    /**
     * 专享标识[0-常规｜1-会员专属]
     * <p>
     * 变更前：`candy_coupon.exclusive`用于根据会员有效期设置券有效期及标识用户端券分类（普通券、会员券等）；
     * 变更后：
     * 原`candy_coupon.exclusive`废除
     * 实际发放逻辑中，原标识"是否根据会员有效期设置券有效期"的`candy_coupon.exclusive`字段改为`candy_mgt_coupon.exclusively`
     * 在`candy_user_coupon`及`candy_common_coupon`中添加`exclusive`字段，发放时直接由`candy_mgt_coupon.exclusively`赋值该属性
     * </p>
     */
    private Integer exclusive;

    /**
     * 公有券状态[1-可用|2-无效｜3-已过期]
     */
    private Integer state;

    /**
     * 公有券范围[10-全体用户｜20-全体会员]
     */
    private Integer ranged;

    /**
     * 操作人
     */
    private String operator;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;

    private String comment;


}
