package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 商城订单属性表
 * </p>
 *
 * @author liquidnet
 * @since 2021-12-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinOrderAttrVo implements Serializable,Cloneable {
    @ApiModelProperty(value = " 住建id")
    private String orderAttrId;
    @ApiModelProperty(value = " 订单id")
    private String orderId;
    @ApiModelProperty(value = " 收货人")
    private String expressContacts;
    @ApiModelProperty(value = " 收货地址[省市区]")
    private String expressAddress;
    @ApiModelProperty(value = " 收货地址[详细]")
    private String expressAddressDetail;
    @ApiModelProperty(value = " 收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(value = " 快递方式 [1寄付|2到付|3-包邮]")
    private Integer expressType;
    @ApiModelProperty(value = " 订单的赠品信息格式为JSON")
    private String giftInfos;
    @ApiModelProperty(value = " 创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    private static final GoblinOrderAttrVo obj = new GoblinOrderAttrVo();

    public static GoblinOrderAttrVo getNew() {
        try {
            return (GoblinOrderAttrVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinOrderAttrVo();
        }
    }
}
