package com.liquidnet.service.sweet.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "SweetStoneIntegralParam", description = "添加减少积分入参")
@Data
public class SweetStoneIntegralParam implements Serializable {

    private static final long serialVersionUID = 561985919908406636L;

    @ApiModelProperty(required = true, value = "用户id", example = "34657843445")
    private String uid;

    @ApiModelProperty(required = true, value = "积分数量", example = "100")
    private Integer score;

    @ApiModelProperty(required = true, value = "描述", example = "抽奖加积分")
    private String content;

    @ApiModelProperty(required = true, value = "增减积分", example = "1增积分 2减积分")
    private Integer type;

    private static final SweetStoneIntegralParam obj = new SweetStoneIntegralParam();
    public static SweetStoneIntegralParam getNew() {
        try {
            return (SweetStoneIntegralParam) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetStoneIntegralParam();
        }
    }

}
