package com.liquidnet.service.goblin.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 积分增减队列消息体
 *
 * @author jiangxiulong
 */
@Data
public class GoblinQueueBizIntegralDto implements Serializable, Cloneable {

    private static final long serialVersionUID = 7538372638864080920L;

    private String content;
    private BigDecimal score;
    private String uid;
    private int type; // 1增 2减

    private static final GoblinQueueBizIntegralDto obj = new GoblinQueueBizIntegralDto();

    public static GoblinQueueBizIntegralDto getNew() {
        try {
            return (GoblinQueueBizIntegralDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinQueueBizIntegralDto();
        }
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
