package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.base.PagedResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.time.LocalDateTime;

@ApiModel(value = "GoblinUserDigitalArtworkPageVo", description = "我的藏品信息")
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinUserDigitalArtworkPageVo implements Cloneable {
    @ApiModelProperty(position = 11, value = "藏品数量")
    private int artworkNum;
    @ApiModelProperty(position = 12, value = "藏品列表分页数据")
    private PagedResult<GoblinUserDigitalArtworkListVo> pagedResult;

    @ApiModelProperty(position = 13, value = "系统当前时间")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime systime;

    public int getArtworkNum() {
        return artworkNum;
    }

    public PagedResult<GoblinUserDigitalArtworkListVo> getPagedResult() {
        return pagedResult;
    }

    public LocalDateTime getSystime() {
        return systime;
    }

    public GoblinUserDigitalArtworkPageVo setArtworkNum(int artworkNum) {
        this.artworkNum = artworkNum;
        return this;
    }

    public GoblinUserDigitalArtworkPageVo setPagedResult(PagedResult<GoblinUserDigitalArtworkListVo> pagedResult) {
        this.pagedResult = pagedResult;
        return this;
    }

    public GoblinUserDigitalArtworkPageVo setSystime(LocalDateTime systime) {
        this.systime = systime;
        return this;
    }

    private static final GoblinUserDigitalArtworkPageVo obj = new GoblinUserDigitalArtworkPageVo();

    public static GoblinUserDigitalArtworkPageVo getNew() {
        try {
            return (GoblinUserDigitalArtworkPageVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinUserDigitalArtworkPageVo();
        }
    }
}
