package com.liquidnet.service.kylin.dto.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 推荐活动关联表
 * </p>
 *
 * @author liquidnet
 * @since 2022-07-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class KylinRecommendActiveRelationParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long mid;

    /**
     * 推荐活动关系id
     */
    @ApiModelProperty(value = "推荐活动关系id")
    private String recommendRelationId;

    /**
     * 推荐商品id
     */
    @ApiModelProperty(value = "推荐商品id")
    private String recommendBindId;

    /**
     * 1NFT2组合购3演出4商品
     */
    @ApiModelProperty(value = "1NFT2组合购3演出4商品")
    private Integer type;

    /**
     * 推荐活动id(关联id)
     */
    @ApiModelProperty(value = "推荐活动id(关联id)")
    private String recommendActiveId;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 修改时间
     */
    private LocalDateTime updatedAt;
    /**
     *
     */
    @ApiModelProperty(value = "排序")
    private Integer indexs;


}
