package com.liquidnet.client.admin.zhengzai.stone.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.zhengzai.stone.service.IItemService;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.dao.PerformanceAdminListDao;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.mapper.StoneScoreItemsMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;


@Service
@Slf4j
public class ItemServiceImpl implements IItemService {

    @Autowired
    StoneScoreItemsMapper stoneScoreItemsMapper;

    @Override
    /**
     * 积分商品列表
     *
     * @param title  名称
     * @param status 状态[-999-全部|1-上架中|2-待上架|7-已下架]
     * @param type   类型[1-券]
     * @return
     */
    public PageInfo<StoneScoreItems> ItemList(String title, Integer status, Integer type) {
        PageInfo<StoneScoreItems> pageInfo;
        LocalDateTime now = LocalDateTime.now();
        List<StoneScoreItems> newList = new ArrayList();
        LambdaQueryWrapper<StoneScoreItems> queryWrapper = Wrappers.lambdaQuery(StoneScoreItems.class).ne(StoneScoreItems::getStatus, -1);
        if (!(title == null || title.equals(""))) {
            queryWrapper.like(StoneScoreItems::getTargetTitle, title);
        }
        if (status != -999) {
            if (status == 2) {//待上架
                queryWrapper.eq(StoneScoreItems::getStatus, 2).gt(StoneScoreItems::getStartTime, now);
            } else if (status == 7) {//已下架
                queryWrapper.eq(StoneScoreItems::getStatus, 2).lt(StoneScoreItems::getEndTime, now);
            } else if (status == 1) {
                queryWrapper.eq(StoneScoreItems::getStatus, 1).or().lt(StoneScoreItems::getStartTime, now).gt(StoneScoreItems::getEndTime, now);
            }
        }
        if (type != -1) {
            queryWrapper.eq(StoneScoreItems::getType, type);
        }
        List<StoneScoreItems> voList = stoneScoreItemsMapper.selectList(queryWrapper);
        for (StoneScoreItems item : voList) {
            if (item.getStatus() == 2) {
                if (now.isAfter(item.getStartTime())) {//未上架
                    item.setStatus(2);
                } else if (now.isBefore(item.getEndTime())) {//已下架
                    item.setStatus(7);
                } else {
                    item.setStatus(1);//上架中
                }
            }
            newList.add(item);
        }
        pageInfo = new PageInfo(newList);
        return pageInfo;
    }
}
