package com.liquidnet.service.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class SmileUserController {
    @Autowired
    private RedisUtil redisUtil;

    @GetMapping("getUser")
    @ApiOperation("获取用户状态，如果没查到，则返回null")
    public ResponseDto<SmileUserVO> getUser() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVO= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        return ResponseDto.success(smileUserVO);
    }




}
