package com.liquidnet.service.stone.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.stone.service.IStoneScoreItemsService;
import com.liquidnet.service.stone.vo.StoneItemListVo;
import com.liquidnet.service.stone.vo.StoneScoreItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "积分-商品相关")
@RestController
@RequestMapping("item")
@Validated
public class StoneItemController {

    @Autowired
    IStoneScoreItemsService stoneScoreItemsService;

    @GetMapping("list")
    @ApiOperation("积分商品列表")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<PageInfo<List<StoneItemListVo>>> itemList(@RequestParam("page") @Valid Integer page) {
        return ResponseDto.success(stoneScoreItemsService.itemList(page, 40));
    }

    @GetMapping("details")
    @ApiOperation("积分商品详情")
    @ApiResponse(code = 200, message = "接口返回对象参数")
    public ResponseDto<StoneScoreItemVo> itemDetails(@RequestParam("itemId") @Valid String itemId) {
        return stoneScoreItemsService.itemDetails(itemId);
    }

}
