package com.liquidnet.service.adam.dto.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import com.liquidnet.service.adam.util.MemberUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel(value = "AdamMemberCodeAdminVo", description = "会员码兑换")
@Data
public class AdamMemberCodeVo implements Serializable, Cloneable {
    private static final long serialVersionUID = 5258094625450569125L;

    @ApiModelProperty(position = 0, value = "会员码")
    private String code;

    @ApiModelProperty(position = 1, value = "会员类型id")
    private String memberId;

    @ApiModelProperty(position = 2, value = "会员价格id")
    private String memberPriceId;

    @ApiModelProperty(position = 3, value = "会员码类型0购买1后台生成")
    private String type;

    @ApiModelProperty(position = 4, value = "会员编号")
    private String memberNo;

    @ApiModelProperty(position = 5, value = "会员状态0-未使用 1-已使用 2-不可用")
    private Integer state;

    /**
     * 购买会员码订单号
     */
    @ApiModelProperty(position = 6, value = "购买会员码的订单编号")
    private String buyOrderNo;
    /**
     * 购买会员码的用户id
     */
    @ApiModelProperty(position = 7, value = "购买会员码的用户id")
    private String buyUid;
    /**
     * 购买时间
     */
    @ApiModelProperty(position = 8, value = "购买时间")
    private String buyAt;
    /**
     * 使用会员码的订单号
     */
    @ApiModelProperty(position = 9, value = "使用会员码的订单编号")
    private String useOrderNo;
    /**
     * 使用会员码的用户ID
     */
    @ApiModelProperty(position = 10, value = "使用会员码的用户id")
    private String useUid;
    /**
     * 使用时间
     */
    @ApiModelProperty(position = 11, value = "使用时间")
    private String useAt;
    /**
     * 会员码id
     */
    @ApiModelProperty(position = 12, value = "会员码id")
    private String memberCodeId;

    private String createdAt;
    private String updatedAt;

    private static final AdamMemberCodeVo obj = new AdamMemberCodeVo();

    public static AdamMemberCodeVo getNew() {
        try {
            return (AdamMemberCodeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new AdamMemberCodeVo();
    }


    /**
     * 整合数据，适合插入数据库的数据(购买码)
     * @param param
     * @param state 0-购买 1-生成
     * @return
     */
    @JsonIgnore
    public AdamMemberCode setCodeParam(AdamMemberCodeParam param, int state) {
        int type = 0;
        String memberNo = "";
        String code = MemberUtil.getMemberCode(type);
        AdamMemberCode adamMemberCode = new AdamMemberCode();
        adamMemberCode.setType(type);
        adamMemberCode.setCode(code);
        adamMemberCode.setMemberId(param.getMemberId());
        adamMemberCode.setMemberPriceId(param.getMemberPriceId());
        adamMemberCode.setState(state);
        adamMemberCode.setMemberNo(memberNo);
        return adamMemberCode;
    }
}
