package com.liquidnet.service.base;

import com.liquidnet.commons.lang.util.JsonUtils;

import java.io.Serializable;

/**
 * REDIRECT(-1),
 * SUCCESS(0),
 * FAIL(1),
 * UNAUTH(2),
 */
public class ResponseDto<T> implements Serializable, Cloneable {
    private static final long serialVersionUID = 8377276776600901982L;
    private String code;
    private String message;
    private T data;

    public boolean isSuccess() {
        return this.code.equals("0");
    }

    private ResponseDto() {
    }

    private ResponseDto(String code) {
        this.code = code;
    }

    private ResponseDto(String code, T data) {
        this.code = code;
        this.data = data;
    }

    private ResponseDto(String code, String message) {
        this.code = code;
        this.message = message;
    }

    private ResponseDto(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    private ResponseDto(ErrorMapping.ErrorMessage errorMessage) {
        this.code = errorMessage.getCode();
        this.message = errorMessage.getMessage();
    }

    private ResponseDto(ErrorMapping.ErrorMessage errorMessage, T data) {
        this.code = errorMessage.getCode();
        this.message = errorMessage.getMessage();
        this.data = data;
    }

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    /**
     * <p>Getter for the field <code>data</code>.</p>
     *
     * @return a T object.
     */
    public T getData() {
        return data;
    }

    public static <Object> ResponseDto<Object> success() {
        return new ResponseDto<>("0");
    }

    public static <Object> ResponseDto<Object> success(Object data) {
        return new ResponseDto<>("0", data);
    }

    public static <Object> ResponseDto<Object> failure() {
        return new ResponseDto<>("1", "系统繁忙，请稍后再试");
    }

    public static <Object> ResponseDto<Object> failure(String message) {
        return new ResponseDto<>("1", message);
    }

    public static <Object> ResponseDto<Object> failure(String code, String message) {
        return new ResponseDto<>(code, message);
    }

    public static <Object> ResponseDto<Object> failure(String code, String message, Object data) {
        return new ResponseDto<>(code, message, data);
    }

    public static <Object> ResponseDto<Object> failure(ErrorMapping.ErrorMessage errorMessage) {
        return new ResponseDto<>(errorMessage);
    }

    public static <Object> ResponseDto<Object> failure(ErrorMapping.ErrorMessage errorMessage, Object data) {
        return new ResponseDto<>(errorMessage, data);
    }

    public <T> T getParseData(Class<T> clazz) {
        try {
            if (getData() != null) {
                return JsonUtils.fromJson(JsonUtils.toJson(getData()), clazz);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
