package com.liquidnet.service.chime.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ChimeUserListQueryReqDto
 * @Package com.liquidnet.service.chime.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/9 12:05
 */
@Data
public class PerformanceQueryReqDto {
    @ApiModelProperty(position = 0,value = "演出ID", example = "")
    private String performanceId;

    @ApiModelProperty(position = 1,value = "排序类型 1创建时间倒序 2创建时间正序 3演出时间倒序 4演出时间正序", example = "0")
    @NotNull(message = "排序类型不能为空")
    private Integer orderType;

    @ApiModelProperty(value = "每页记录数", example = "20")
    @NotNull(message = "每页记录数不能为空")
    private Integer pageSize;

    @ApiModelProperty(value = "当前页", example = "0")
    @NotNull(message = "当前页不能为空")
    private Integer pageNum;

    @ApiModelProperty(value = "排序字段", hidden = true)
    private String orderItem;
    @ApiModelProperty(value = "排序方式", hidden = true)
    private String orderSc;

    public void setOrderType(Integer orderType) {
        this.orderType = orderType;
        switch (orderType) {
            case 1: {
                orderItem = "created_at";
                orderSc = "desc";
                break;
            }
            case 2: {
                orderItem = "created_at";
                orderSc = "asc";
                break;
            }
            case 3: {
                orderItem = "time_start";
                orderSc = "desc";
                break;
            }
            case 4: {
                orderItem = "time_start";
                orderSc = "asc";
                break;
            }

        }
    }

    private static final PerformanceQueryReqDto obj = new PerformanceQueryReqDto();

    public static PerformanceQueryReqDto getNew() {
        try {
            return (PerformanceQueryReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new PerformanceQueryReqDto();
        }
    }
}
