package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.liquidnet.service.kylin.dao.report.PerformanceAgeDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceCityDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceProvinceDataDto;
import com.liquidnet.service.kylin.dao.report.PerformanceSexDataDto;
import com.liquidnet.service.kylin.mapper.ReportPerformanceMapper;
import com.liquidnet.service.kylin.service.IReportPerformanceService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ReportPerformanceServiceImpl
 * @Package com.liquidnet.client.admin.zhengzai.kylin.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/9/23 11:30
 */
@Slf4j
@Service
public class ReportPerformanceServiceImpl implements IReportPerformanceService {
    @Autowired
    private ReportPerformanceMapper reportPerformanceMapper;
    @Override
    public List<PerformanceProvinceDataDto> getProvinceDataList(String performanceId) {
        return reportPerformanceMapper.getProvinceDataList(performanceId);
    }

    @Override
    public List<PerformanceCityDataDto> getCityDataList(String performanceId) {
        return reportPerformanceMapper.getCityDataList(performanceId);
    }

    @Override
    public List<PerformanceAgeDataDto> getAgeDataList(String performanceId) {
        return reportPerformanceMapper.getAgeDataList(performanceId);
    }

    @Override
    public List<PerformanceSexDataDto> getSexDataList(String performanceId) {
        return reportPerformanceMapper.getSexDataList(performanceId);
    }
}
