package com.liquidnet.service.sweet.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.param.SweetLostFoundAdminParam;
import com.liquidnet.service.sweet.param.ValidationGroups;
import com.liquidnet.service.sweet.service.ISweetLostFoundAdminService;
import com.liquidnet.service.sweet.vo.SweetLostFoundAdminVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 失物招领管理员Controller
 *
 * @author liquidnet
 * @since 2025-01-18
 */
@RestController
@RequestMapping("/lost-found/admin")
@Api(value = "失物招领管理员管理", tags = "失物招领管理员管理")
@Validated
public class SweetLostFoundAdminController {

    @Autowired
    private ISweetLostFoundAdminService sweetLostFoundAdminService;

    @PostMapping("/add")
    @ApiOperation("添加管理员")
    public ResponseDto<Boolean> addAdmin(@RequestBody @Validated SweetLostFoundAdminParam admin) {
        return sweetLostFoundAdminService.addAdmin(admin);
    }

    @PutMapping("/update")
    @ApiOperation("编辑管理员")
    public ResponseDto<Boolean> updateAdmin(@RequestBody @Validated({ValidationGroups.Update.class}) SweetLostFoundAdminParam admin) {
        return sweetLostFoundAdminService.editAdmin(admin);
    }

    @DeleteMapping("/delete/{id}")
    @ApiOperation("删除管理员")
    public ResponseDto<Boolean> deleteAdmin(
            @ApiParam("管理员ID") @PathVariable Long id) {
        return ResponseDto.success(sweetLostFoundAdminService.deleteAdmin(id));
    }

    @GetMapping("/detail/{id}")
    @ApiOperation("获取管理员详情")
    public ResponseDto<SweetLostFoundAdminVo> getAdminDetail(
            @ApiParam("管理员ID") @PathVariable Long id) {
        return ResponseDto.success(sweetLostFoundAdminService.getAdminDetail(id));
    }

    @GetMapping("/list/{performanceId}")
    @ApiOperation("获取管理员列表")
    public ResponseDto<List<SweetLostFoundAdminVo>> getAdminList(@ApiParam("演出ID") @PathVariable String performanceId) {
        return ResponseDto.success(sweetLostFoundAdminService.getAdminList(performanceId));
    }

    @GetMapping("/permission/{phone}/{performanceId}")
    @ApiOperation("获取权限")
    /**
     * 1. 删除不能图简单直接删除两个 key 这样容易删除单站把全站的也删除掉
     * 2. 不能再读取的时候读不到在查 sql 再写入 redis 这里的情况不适用，没权限的用户导致一直查 sql 了
     * 另外还会导致因为权限混在一起，crud 的时候考虑的会太复杂，现在分开处理逻辑就简单些，所以要在 cu的写入 redis
     */
    public ResponseDto<SweetLostFoundAdminVo> getPermission(
            @ApiParam("手机号") @PathVariable String phone,
            @ApiParam("演出ID") @PathVariable String performanceId) {
        return ResponseDto.success(sweetLostFoundAdminService.hasPermission(phone, performanceId));
    }
}