package com.liquidnet.service.goblin.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * mongo队列消息体
 *
 * @author jiangxiulong
 */
@Data
public class GoblinQueueBizMongoDto implements Serializable, Cloneable {

    private static final long serialVersionUID = -5850588358672254766L;

    /**
     * mongo操作入队列
     *
     * @param bizId 业务id 例如orderId
     * @param bizType 业务类型 1NFT订单 2...
     * @param opType 操作类型 1创建 2修改
     * @param listType 队列类型 1即时性要求高队列 2即时性要求不高队列
     */
    private String bizId;
    private int bizType;
    private int opType;
    private int listType;

    private static final GoblinQueueBizMongoDto obj = new GoblinQueueBizMongoDto();

    public static GoblinQueueBizMongoDto getNew() {
        try {
            return (GoblinQueueBizMongoDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinQueueBizMongoDto();
        }
    }

    public String toJson() {
        return JsonUtils.toJson(this);
    }
}
