package com.liquidnet.service.sweet.constant;

/**
 *
 */
public class SweetConstant {

    public final static String REDIS_KEY_SWEET_MANUAL_PUSH_LIST = "sweet:manual:pushList";
    public final static String REDIS_KEY_SWEET_MANUAL_TIME_LIST = "sweet:manual:timeList:manual:";
    public final static String REDIS_KEY_SWEET_MANUAL_NOTIFY_LIST = "sweet:manual:notify:manual:";
    public final static String REDIS_KEY_SWEET_MANUAL_RICH_TEXT = "sweet:manual:richText:manual:";
    public final static String REDIS_KEY_SWEET_MANUAL_SORT = "sweet:manual:sort:manual:";

    public final static String REDIS_KEY_SWEET_ARTISTS_RELATION = "sweet:artists:relation:uid:";
    public final static String REDIS_KEY_SWEET_ARTISTS_DETAILS = "sweet:artists:details:";
    public final static String REDIS_KEY_SWEET_SHOP = "sweet:artists:shop:manual:";


    public final static String REDIS_KEY_SWEET_REMIND="sweet:remind:unionId:";
    public static final String REDIS_KEY_SWEET_REMIND_ALL = "sweet:remind:unionId*";

    public final static String REDIS_KEY_SWEET_WECHAT_USER_INFO="sweet:wechatUser:unionId:";

    public enum ManualPosition {
        artist("艺人","artist"),
        signingTime("签售时间","signingTime"),
        foodAndAmusement("吃喝玩乐","foodAndAmusement"),
        siteMap("现场地图","siteMap"),
        howToReach("如何到达","howToReach"),
        relatedProduct ("官方售卖","relatedProduct"),
        officialSupport("官方支持","officialSupport"),
        audienceNotice("观众须知","audienceNotice"),
        preventionGuidelines("防疫指南","preventionGuidelines"),
        notice("通知","notice"),
        strategy("观演攻略","strategy");

        private String message;
        private String code;

        private ManualPosition(String message, String code) {
            this.message = message;
            this.code = code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return code;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return message;
        }

        public static String getMessage(String code) {
            for (ManualPosition c : ManualPosition.values()) {
                if (c.getCode().equalsIgnoreCase(code)) {
                    return c.message;
                }
            }
            return null;
        }
    }
}
