package com.liquidnet.service.goblin.service.impl.manage;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.goblin.constant.GoblinStatusConst;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.entity.GoblinOrderOperationLog;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreMoneyService;
import com.liquidnet.service.goblin.service.manage.IGoblinStoreOrderService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.ObjectUtil;
import com.liquidnet.service.goblin.util.QueueUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

@Service
public class GoblinStoreOrderServiceImpl implements IGoblinStoreOrderService {

    @Autowired
    GoblinRedisUtils redisUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    QueueUtils queueUtils;

    @Override
    public ResponseDto<PageInfo<GoblinStoreOrderListVo>> orderList(Integer page, String orderCode, Integer type, String cst, String cet, String expressContacts, String phone, Integer status) {
        List<GoblinStoreOrderListVo> listVos = ObjectUtil.getGoblinStoreOrderListVoArrayList();
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        HashMap<String, Object> map = mongoUtils.storeOrderList(storeInfoVo.getStoreId(), page, orderCode, cst, cet, expressContacts, phone, status);
        long total = (long) map.get("total");
        List<GoblinStoreOrderVo> voList = (List<GoblinStoreOrderVo>) map.get("data");
        for (GoblinStoreOrderVo item : voList) {
            GoblinStoreOrderListVo vo = GoblinStoreOrderListVo.getNew();
            vo.setCreatedAt(item.getCreatedAt());
            vo.setExpressAddressDetail(item.getOrderAttrVo().getExpressAddressDetail());
            vo.setExpressContacts(item.getOrderAttrVo().getExpressContacts());
            vo.setExpressPhone(item.getOrderAttrVo().getExpressPhone());
            vo.setOrderCode(item.getOrderCode());
            vo.setExpressAddress(item.getOrderAttrVo().getExpressAddress());
            vo.setOrderId(item.getOrderId());
            vo.setPayType(item.getPayType());
            vo.setPriceActual(item.getPriceActual());
            vo.setStatus(item.getStatus());
            vo.setPriceExpress(item.getPriceExpress());
            List<GoblinStoreOrderListSkuVo> orderListSkuVos = ObjectUtil.getGoblinStoreOrderListSkuVoArrayList();
            for (String skuId : item.getOrderSkuVoIds()) {
                GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(skuId);
                GoblinStoreOrderListSkuVo itemSkuVo = GoblinStoreOrderListSkuVo.getNew();
                itemSkuVo.setNum(orderSkuVo.getNum());
                itemSkuVo.setOrderSkuId(orderSkuVo.getOrderSkuId());
                itemSkuVo.setSkuId(orderSkuVo.getSkuId());
                itemSkuVo.setSkuName(orderSkuVo.getSkuName());
                itemSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual());
                itemSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
                itemSkuVo.setSkuImage(orderSkuVo.getSkuImage());
                orderListSkuVos.add(itemSkuVo);
            }
            vo.setStoreOrderListSkuVoList(orderListSkuVos);
            listVos.add(vo);
        }
        PageInfo<GoblinStoreOrderListVo> pageInfo = new PageInfo(listVos);
        pageInfo.setTotal(total);
        return ResponseDto.success(pageInfo);
    }

    @Override
    public ResponseDto<GoblinStoreOrderListVo> orderDetails(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        GoblinStoreOrderListVo vo = GoblinStoreOrderListVo.getNew();
        vo.setCreatedAt(orderVo.getCreatedAt());
        vo.setExpressAddressDetail(orderVo.getOrderAttrVo().getExpressAddressDetail());
        vo.setExpressContacts(orderVo.getOrderAttrVo().getExpressContacts());
        vo.setExpressPhone(orderVo.getOrderAttrVo().getExpressPhone());
        vo.setOrderCode(orderVo.getOrderCode());
        vo.setExpressAddress(orderVo.getOrderAttrVo().getExpressAddress());
        vo.setOrderId(orderVo.getOrderId());
        vo.setPayType(orderVo.getPayType());
        vo.setPriceActual(orderVo.getPriceActual());
        vo.setStatus(orderVo.getStatus());
        vo.setPayTime(orderVo.getPayTime());
        vo.setPriceExpress(orderVo.getPriceExpress());
        vo.setLogisticsCompany(orderVo.getLogisticsCompany());
        List<GoblinStoreOrderListSkuVo> orderListSkuVos = ObjectUtil.getGoblinStoreOrderListSkuVoArrayList();
        for (String skuId : orderVo.getOrderSkuVoIds()) {
            GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(skuId);
            GoblinStoreOrderListSkuVo itemSkuVo = GoblinStoreOrderListSkuVo.getNew();
            itemSkuVo.setNum(orderSkuVo.getNum());
            itemSkuVo.setOrderSkuId(orderSkuVo.getOrderSkuId());
            itemSkuVo.setSkuId(orderSkuVo.getSkuId());
            itemSkuVo.setSkuName(orderSkuVo.getSkuName());
            itemSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual());
            itemSkuVo.setSkuSpecs(orderSkuVo.getSkuSpecs());
            itemSkuVo.setSkuImage(orderSkuVo.getSkuImage());
            orderListSkuVos.add(itemSkuVo);
        }
        vo.setStoreOrderListSkuVoList(orderListSkuVos);
        return ResponseDto.success(vo);
    }

    @Override
    public ResponseDto<Boolean> orderCancel(String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        String nowStr = DateUtil.getNowTime();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        orderVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_5.getValue());
        orderVo.setCancelReason("商铺取消");
        orderVo.setCancelTime(nowStr);
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_14.getValue());
        log.setRemark("商铺取消订单");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.cancel",
                        orderVo.getStatus(), now, orderVo.getCancelReason(), now,
                        orderId, now, now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeExpressPrice(String orderId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue()) {
            return ResponseDto.failure("已发货");
        }
        orderVo.setPriceModify(orderVo.getPriceModify().add(price));
        orderVo.setPriceVoucher(orderVo.getPriceVoucher().add(price));
        orderVo.setPriceActual(orderVo.getPriceActual().multiply(price));
        orderVo.setPriceExpress(price);
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_17.getValue());
        log.setRemark("expressPress=[" + price + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.orderExpressPrice",
                        orderVo.getPriceModify(), orderVo.getPriceVoucher(), orderVo.getPriceActual(), orderVo.getPriceExpress(), now,
                        orderId, now, now
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeAddress(String orderId, String expressAddressDetail, String expressContacts, String expressPhone) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_3.getValue()) {
            return ResponseDto.failure("已发货");
        }
        orderVo.getOrderAttrVo().setExpressAddressDetail(expressAddressDetail);
        orderVo.getOrderAttrVo().setExpressContacts(expressContacts);
        orderVo.getOrderAttrVo().setExpressPhone(expressPhone);
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_17.getValue());
        log.setRemark("expressContacts=[" + expressContacts + "],expressPhone=[" + expressPhone + "],expressAddressDetail=[" + expressAddressDetail + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        //mysql
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.address",
                        expressContacts, expressPhone, expressAddressDetail, now, orderId, now, now
                )
        );
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> changeSkuPrice(String orderId, String orderSkuId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        if (orderVo.getStatus() == GoblinStatusConst.Status.ORDER_STATUS_0.getValue()) {
            return ResponseDto.failure("已发货");
        }
        GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
        if (orderSkuVo == null) {
            return ResponseDto.failure("不存在");
        }
        orderSkuVo.setPriceModify(price);
        orderSkuVo.setPriceVoucher(orderSkuVo.getPriceVoucher().add(price));
        orderSkuVo.setSkuPriceActual(orderSkuVo.getSkuPriceActual().multiply(price));
        orderVo.setPriceModify(orderVo.getPriceModify().add(price));
        orderVo.setPriceVoucher(orderVo.getPriceVoucher().add(price));
        orderVo.setPriceActual(orderVo.getPriceActual().multiply(price));
        GoblinOrderOperationLog log = initLog(orderId, uid, now);
        log.setType(GoblinStatusConst.Status.ORDER_LOG_STATUS_12.getValue());
        log.setRemark("orderSkuId=[" + orderSkuId + "],price=[" + price + "]");
        //redis
        redisUtils.setGoblinOrder(orderId, orderVo);
        redisUtils.setGoblinOrderSku(orderSkuId, orderSkuVo);
        //mongo
        mongoUtils.updateGoblinStoreOrderVo(orderId, orderVo);
        mongoUtils.updateGoblinOrderSkuVo(orderSkuId, orderSkuVo);
        //mysql
        LinkedList<String> sqls = CollectionUtil.linkedListString();
        LinkedList<Object[]> sqlsOrder = CollectionUtil.linkedListObjectArr();
        LinkedList<Object[]> sqlsOrderSku = CollectionUtil.linkedListObjectArr();
        sqls.add(SqlMapping.get("goblin_order.store.orderPrice"));
        sqls.add(SqlMapping.get("goblin_order.store.orderSkuPrice"));
        sqlsOrder.add(new Object[]{
                orderVo.getPriceModify(), orderVo.getPriceVoucher(), orderVo.getPriceActual(), now,
                orderId, now, now
        });
        sqlsOrderSku.add(new Object[]{
                orderSkuVo.getPriceModify(), orderSkuVo.getPriceVoucher(), orderSkuVo.getSkuPriceActual(), now,
                orderSkuId, now, now
        });
        queueUtils.sendMsgByRedis(MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.gets(sqls, sqlsOrder, sqlsOrderSku));
        //添加日志
        queueUtils.sendMsgByRedis(
                MQConst.GoblinQueue.GOBLIN_STORE_ORDER_OPERA.getKey(),
                SqlMapping.get("goblin_order.store.log",
                        log.getOrderLogId(), log.getOrderId(), log.getType(), log.getRemark(), log.getOperationName(), now
                )
        );
        return ResponseDto.success();
    }

    @Override
    public ResponseDto<Boolean> refundOrderSku(String orderId, String orderSkuId, BigDecimal price) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        GoblinOrderSkuVo orderSkuVo = redisUtils.getGoblinOrderSkuVo(orderSkuId);
        if (orderSkuVo == null) {
            return ResponseDto.failure("不存在");
        }
        orderSkuVo.setPriceRefund(orderSkuVo.getPriceRefund().add(price));
        orderVo.setPriceRefund(orderVo.getPriceRefund().add(price));
        if (orderSkuVo.getPriceRefund().compareTo(orderSkuVo.getSkuPriceActual()) == 0) {
            orderSkuVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_6.getValue());
        }
        if (orderVo.getPriceRefund().compareTo(orderVo.getPriceActual()) == 0) {
            orderSkuVo.setStatus(GoblinStatusConst.Status.ORDER_STATUS_6.getValue());
        }
        return null;
    }

    @Override
    public ResponseDto<Boolean> refundOrder(String orderId, BigDecimal orderPrice, BigDecimal expressPrice) {
        String uid = CurrentUtil.getCurrentUid();
        LocalDateTime now = LocalDateTime.now();
        GoblinStoreInfoVo storeInfoVo = redisUtils.getStoreInfoVoByUid(uid);
        if (storeInfoVo == null) {
            return ResponseDto.failure("无法查看");
        }
        GoblinStoreOrderVo orderVo = redisUtils.getGoblinOrder(orderId);
        if (orderVo == null || !orderVo.getStoreId().equals(storeInfoVo.getStoreId())) {
            return ResponseDto.failure("无法查看");
        }
        return null;
    }

    private GoblinOrderOperationLog initLog(String orderId, String uid, LocalDateTime now) {
        GoblinOrderOperationLog log = GoblinOrderOperationLog.getNew();
        log.setOrderId(orderId);
        log.setOperationName(uid);
        log.setOrderLogId(IDGenerator.nextTimeId2());
        log.setCreatedAt(now);
        return log;
    }
}
