package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.ShiroUtils;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfGoodsCategoryService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinSelfGoodsCategory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.time.LocalDateTime;

@Api(tags = "商品分类")
@Controller
@RequestMapping("goblin/category")
public class GoblinSelfCategoryController extends BaseController {
    private final String prefix = "zhengzai/goblin/category";
    @Autowired
    IGoblinSelfGoodsCategoryService goblinSelfGoodsCategoryService;

    @GetMapping()
    public String category() {
        return prefix.concat("/category");
    }

    @RequiresPermissions("goblin:category:list")
    @RequestMapping("list")
    @ResponseBody
    public TableDataInfo list() {
        PageHelper.startPage(0, 1000, "mid");
        return getDataTable(goblinSelfGoodsCategoryService.listForForMultiGrade());
    }

    @ApiOperation(value = "新建")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "grade", value = "分类层级[1-一级|2-二级|3-三级]", allowableValues = "1,2,3"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "catePid", value = "分类父ID[30]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "name", value = "分类名称[50]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "icon", value = "分类图标[256]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "neIsbn", value = "是否需要填写ISBN[0-否|1-是]", allowableValues = "0,1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "Integer", name = "sort", value = "排序[数值越小,排序越前]", example = "1"),
    })
    @Log(title = "店铺管理:商品分类:新建", businessType = BusinessType.INSERT)
    @RequiresPermissions("goblin:category:add")
    @PostMapping("addSave")
    @ResponseBody
    public AjaxResult addSave(GoblinSelfGoodsCategory selfGoodsCategory) {
        // TODO: 2022/1/14 zhanggb valid

        selfGoodsCategory.setCateId(IDGenerator.nextMilliId2());
        selfGoodsCategory.setCreatedBy(ShiroUtils.getLoginName());
        selfGoodsCategory.setCreatedAt(LocalDateTime.now());

        return toAjax(goblinSelfGoodsCategoryService.save(selfGoodsCategory));
    }

    @Log(title = "店铺管理:商品分类:删除", businessType = BusinessType.DELETE)
    @RequiresPermissions("goblin:category:rmv")
    @PostMapping("rmv")
    @ResponseBody
    public AjaxResult rmv(String cateIds) {
        String loginName = ShiroUtils.getLoginName();
        LocalDateTime now = LocalDateTime.now();
        String[] cateIdArr = Convert.toStrArray(cateIds);
        return toAjax(goblinSelfGoodsCategoryService.update(Wrappers.lambdaUpdate(GoblinSelfGoodsCategory.class)
                .in(GoblinSelfGoodsCategory::getCateId, cateIdArr)
                .in(GoblinSelfGoodsCategory::getCatePid, cateIdArr)
                .set(GoblinSelfGoodsCategory::getDelFlg, "1")
                .set(GoblinSelfGoodsCategory::getUpdatedBy, loginName)
                .set(GoblinSelfGoodsCategory::getUpdatedAt, now)
                .set(GoblinSelfGoodsCategory::getDeletedBy, loginName)
                .set(GoblinSelfGoodsCategory::getDeletedAt, now)
        ));
    }

}
