package com.liquidnet.client.admin.web.controller.zhengzai.goblin;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.common.enums.BusinessType;
import com.liquidnet.client.admin.common.utils.poi.ExcelUtil;
import com.liquidnet.client.admin.zhengzai.goblin.dto.GoblinSelfExtagExcelDto;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinSelfTagService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinSelfTag;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Api(tags = "音乐人标签库")
@Controller
@RequestMapping("goblin/extag")
public class GoblinSelfExtagController extends BaseController {
    private final String prefix = "zhengzai/goblin/extag";
    @Autowired
    IGoblinSelfTagService goblinSelfTagService;

    @GetMapping()
    public String extag() {
        return prefix.concat("/extag");
    }

    @RequiresPermissions("goblin:extag:list")
    @RequestMapping("list")
    @ResponseBody
    public TableDataInfo list(GoblinSelfTag selfTag) {
        startPage();
        return getDataTable(listQuery(selfTag));
    }

    private List<GoblinSelfTag> listQuery(GoblinSelfTag selfTag) {
        LambdaQueryWrapper<GoblinSelfTag> lambdaQueryWrapper = Wrappers.lambdaQuery(GoblinSelfTag.class);
        lambdaQueryWrapper.eq(GoblinSelfTag::getDelFlg, "0");
        lambdaQueryWrapper.eq(GoblinSelfTag::getTagBelong, "1");
        if (StringUtils.isNotBlank(selfTag.getTagName())) {
            lambdaQueryWrapper.like(GoblinSelfTag::getTagName, selfTag.getTagName());
        }
        if (StringUtils.isNotBlank(selfTag.getTagType())) {
            lambdaQueryWrapper.eq(GoblinSelfTag::getTagType, selfTag.getTagType());
        }

        lambdaQueryWrapper.select(
                GoblinSelfTag::getTagId,
                GoblinSelfTag::getTagName,
                GoblinSelfTag::getTagPic,
                GoblinSelfTag::getTagType,
                GoblinSelfTag::getCounts
        );
        return goblinSelfTagService.list(lambdaQueryWrapper);
    }

    @RequiresPermissions("goblin:extag:export")
    @Log(title = "店铺管理:音乐人标签库:导出", businessType = BusinessType.EXPORT)
    @PostMapping("export")
    @ResponseBody
    public AjaxResult export(GoblinSelfTag selfTag) {
        List<GoblinSelfTag> list = listQuery(selfTag);
        ExcelUtil<GoblinSelfExtagExcelDto> excelUtil = new ExcelUtil<>(GoblinSelfExtagExcelDto.class);
        List<GoblinSelfExtagExcelDto> excelList = new ArrayList<>();
        list.forEach(r -> excelList.add(GoblinSelfExtagExcelDto.getNew().copy(r)));
        return excelUtil.exportExcel(excelList, "音乐人标签库");
    }

    @ApiOperation(value = "新建")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagName", value = "标签名称[50]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagPic", value = "标签图片[256]"),
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "tagType", value = "标签类型[1-音乐人|2-艺术家|3-品牌方|4-厂牌]", allowableValues = "1,2,3,4"),
    })
    @Log(title = "店铺管理:音乐人标签库:新建", businessType = BusinessType.INSERT)
    @RequiresPermissions("goblin:extag:add")
    @PostMapping("addSave")
    @ResponseBody
    public AjaxResult addSave(String tagName, String tagPic, String tagType) {
        GoblinSelfTag selfTag = new GoblinSelfTag();

        selfTag.setTagId(IDGenerator.nextMilliId2());
        selfTag.setTagName(tagName);
        selfTag.setTagPic(tagPic);
        selfTag.setTagType(tagType);
        selfTag.setTagBelong("1");

        return toAjax(goblinSelfTagService.save(selfTag));
    }

    @Log(title = "店铺管理:音乐人标签库:删除", businessType = BusinessType.DELETE)
    @RequiresPermissions("goblin:extag:rmv")
    @PostMapping("rmv")
    @ResponseBody
    public AjaxResult rmv(String extagIds) {
        return toAjax(goblinSelfTagService.update(Wrappers.lambdaUpdate(GoblinSelfTag.class)
                .in(GoblinSelfTag::getTagId, Convert.toStrArray(extagIds))
                .set(GoblinSelfTag::getDelFlg, "1")
        ));
    }
}
