package com.liquidnet.service.goblin.controller;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinFrontBannerVo;
import com.liquidnet.service.goblin.dto.vo.GoblinFrontGoodDetailVo;
import com.liquidnet.service.goblin.dto.vo.GoblinFrontSeckillVo;
import com.liquidnet.service.goblin.dto.vo.GoblinFrontSelectGoodVo;
import com.liquidnet.service.goblin.entity.GoblinFrontHotWord;
import com.liquidnet.service.goblin.entity.GoblinFrontNavigation;
import com.liquidnet.service.goblin.service.impl.GoblinFrontServiceImpl;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangfuxin
 * @Description:前端接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理")
@RestController
@RequestMapping("/front")
public class GoblinFrontController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    private GoblinFrontServiceImpl goblinFrontService;

    @GetMapping("getTopBanner")
    @ApiOperation("获取顶部banner")
    public ResponseDto<ArrayList<GoblinFrontBannerVo>> getBanner() {
        return ResponseDto.success( goblinFrontService.getListBanner());
    }

    @GetMapping("getMiddleBanner")
    @ApiOperation("获取中部banner")
    public ResponseDto<ArrayList<GoblinFrontBannerVo>> getMiddleBanner() {
        return ResponseDto.success( goblinFrontService.getMiddleBanner());
    }
    @GetMapping("getHotWord")
    @ApiOperation("获得热词")
    public ResponseDto<List<GoblinFrontHotWord>> getHotWord() {
        return ResponseDto.success( goblinFrontService.getHotWord() );
    }
    @GetMapping("getNavigation")
    @ApiOperation("获得金刚栏")
    public ResponseDto<List<GoblinFrontNavigation>> getNavigation() {
        return ResponseDto.success( goblinFrontService.getNavigation() );
    }

    @GetMapping("getSeckilll")
    @ApiOperation("获得秒杀首页要用的")
    public ResponseDto<GoblinFrontSeckillVo> getSeckilll() throws ParseException {
        return ResponseDto.success( goblinFrontService.getSeckilll());
    }

    @GetMapping("getSelectGoods")
    @ApiOperation("获得精选商品列表(pageNumber从0开始)")
    public ResponseDto<GoblinFrontSelectGoodVo> getSelectGoods(@RequestParam(name = "pageSize", required = true) int pageSize, @RequestParam(name = "pageNumber", required = true)int pageNumber) throws ParseException {
        return ResponseDto.success( goblinFrontService.getSelectGoods(pageNumber,pageSize));
    }
    @GetMapping("getGoodsDetail")
    @ApiOperation("获得商品详情")
    public ResponseDto<GoblinFrontGoodDetailVo> getGoodsDetail(@RequestParam(name = "spuId", required = true) String spuId) throws ParseException {
        return ResponseDto.success( goblinFrontService.getGoodsDetail(spuId));
    }
    @GetMapping("getMoudleIndex")
    @ApiOperation("获取组件排序")
    public ResponseDto getMoudleIndex() throws ParseException {
        return ResponseDto.success( goblinFrontService.getMoudleIndex());
    }
    @GetMapping("getCube")
    @ApiOperation("获取魔方")
    public ResponseDto getCube() throws ParseException {
        return ResponseDto.success( goblinFrontService.getCube());
    }
    @GetMapping("getCategory")
    @ApiOperation("获取分类")
    public ResponseDto getCategory(String type,String categoryId) throws ParseException {
        return ResponseDto.success( goblinFrontService.getCube());
    }








}
