package com.liquidnet.service.dragon.service.impl;

import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.dragon.channel.alipay.req.AlipayTradePayReq;
import com.liquidnet.service.dragon.channel.alipay.util.AlipayUtil;
import com.liquidnet.service.dragon.constant.DragonConstant;
import com.liquidnet.service.dragon.dto.DragonPayBaseReqDto;
import com.liquidnet.service.dragon.dto.DragonPayBaseRespDto;
import com.liquidnet.service.dragon.entity.DragonOrders;
import com.liquidnet.service.dragon.service.IDragonOrdersService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

@Service
public class DragonOrdersServiceImpl implements IDragonOrdersService {
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Value("liquidnet.dragon.alipay-gataway-url")
    private String alipayGatewayUrl;

    @Override
    public void sendRedisQueue() {
        try {
            HashMap<String ,String> map = new HashMap<>();
            map.put("message","测试 redis 订阅信息1");
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey("dragon-pay");
            stringRedisTemplate.opsForStream().add(record);
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public ResponseDto<DragonPayBaseRespDto> alipay(DragonPayBaseReqDto dragonPayBaseReqDto) {
        AlipayTradePayReq alipayTradePayReq = new AlipayTradePayReq();
        alipayTradePayReq.setProductCode("QUICK_WAP_PAY");
        alipayTradePayReq.setTotalAmount(dragonPayBaseReqDto.getPrice());
        alipayTradePayReq.setSubject(dragonPayBaseReqDto.getName());
        alipayTradePayReq.setBody(dragonPayBaseReqDto.getDetail());
        //dragon中支付编号
        alipayTradePayReq.setOutTradeNo(IDGenerator.payCode());
        alipayTradePayReq.setTimeExpire(dragonPayBaseReqDto.getExpireTime());
        Map<String, Object> result = AlipayUtil.tradeWapPay(alipayTradePayReq);
        DragonPayBaseRespDto respDto = new DragonPayBaseRespDto();
        respDto.setCode(alipayTradePayReq.getOutTradeNo());
        respDto.setOrder_code(dragonPayBaseReqDto.getOrderCode());
        DragonPayBaseRespDto.PayData payData = new DragonPayBaseRespDto.PayData();
        payData.setRedirectUrl(alipayGatewayUrl + result.get("body"));
        respDto.setPay_data(payData);
        //支付订单持久化
        this.buildPayOrders(dragonPayBaseReqDto,respDto);
        return ResponseDto.success(respDto);
    }

    private DragonOrders buildPayOrders(DragonPayBaseReqDto dragonPayBaseReqDto,DragonPayBaseRespDto respDto){
        DragonOrders orders = new DragonOrders();
//        orders.setMid();
        orders.setStatus(Integer.valueOf(DragonConstant.PayStatusEnum.STATUS_UNPAID.getCode()));
        orders.setCode(respDto.getCode());
        orders.setType(dragonPayBaseReqDto.getType());
        orders.setPrice(dragonPayBaseReqDto.getPrice());
        orders.setName(dragonPayBaseReqDto.getName());
        orders.setDetail(dragonPayBaseReqDto.getDetail());
        orders.setOrderCode(dragonPayBaseReqDto.getOrderCode());
        orders.setClientIp(dragonPayBaseReqDto.getClientIp());
        orders.setNotifyUrl(dragonPayBaseReqDto.getNotifyUrl());
        orders.setPaymentType(DragonConstant.PayTypeEnum.PAYMENT_TYPE_APP_IAP.getCode());
//        orders.setPaymentId();
        orders.setPaymentAt(LocalDateTime.now());
//        orders.setFinishedAt();
        orders.setCreatedAt(LocalDateTime.now());
//        orders.setUpdatedAt();
        // 修改退款订单
        boolean insertResult = sendMySqlRedis(
                SqlMapping.get("dragon_orders.insert"),
                new Object[]{orders.getStatus(), orders.getCode(), orders.getType()
                        , orders.getPrice(), orders.getName(), orders.getDetail()
                        , orders.getOrderCode(), orders.getClientIp()
                        , orders.getNotifyUrl(), orders.getPaymentType(),
                        orders.getPaymentId(), orders.getPaymentAt()
                        , orders.getFinishedAt(), orders.getCreatedAt()
                        , orders.getUpdatedAt()}
        );
        return orders;
    }
    /**
     * 给 REDIS 队列发送消息 数据库相关
     *
     * @param sql  sql语句
     * @param data 需要操作的数据
     * @return
     */
    private boolean sendMySqlRedis(String sql, Object[] data) {
        try {
            LinkedList<String> sqls = new LinkedList<>();
            sqls.add(sql);
            LinkedList<Object[]> sqlsData = new LinkedList();
            sqlsData.add(data);
            String sqlData = SqlMapping.gets(sqls, sqlsData);

            HashMap<String, String> map = new HashMap<>();
            map.put("message", sqlData);
            MapRecord<String, String, String> record = StreamRecords.mapBacked(map).withStreamKey(DragonConstant.MysqlRedisQueueEnum.DRAGON_PAY_KEY.getCode());
            stringRedisTemplate.opsForStream().add(record);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}
