package com.liquidnet.service.kylin.dto.vo.returns;

import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.entity.KylinOrderTicketRelations;
import com.liquidnet.service.kylin.entity.KylinOrderTicketStatus;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.dto.vo.admin.OrderRefundAddress;
import com.liquidnet.service.kylin.dto.vo.admin.OrderRefundPoundage;
import com.liquidnet.service.kylin.entity.KylinOrderCoupons;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.ArrayList;

@ApiModel(value = "KylinOrderTicketVo", description = "订单数据")
@Data
public class KylinOrderTicketPreVo implements Serializable, Cloneable {
    private Integer mid;
    private static final long serialVersionUID = 5325511589667456213L;
    @ApiModelProperty(position = 10, value = "订单ID")
    private String orderTicketsId;
    @ApiModelProperty(position = 11, value = "用户ID[64]")
    private String userId;
    @ApiModelProperty(position = 12, value = "用户昵称")
    private String userName;
    @ApiModelProperty(position = 13, value = "用户手机号")
    private String userMobile;
    @ApiModelProperty(value = "购票数量")
    private Integer number;
    @ApiModelProperty(value = "应付价格")
    private BigDecimal priceTotal;
    @ApiModelProperty(value = "优惠价格")
    private BigDecimal priceActual;
    @ApiModelProperty(value = "快递价格")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = "退款价格")
    private BigDecimal priceRefund;
    @ApiModelProperty(value = "退款张数")
    private Integer refundNumber;
    @ApiModelProperty(value = "是否使用优惠卷 exchange/no")
    private String couponType;
    @ApiModelProperty(value = "取票方式 电子票electronic快递票express")
    private String getTicketType;

    @ApiModelProperty(value = "快递类型 1寄付 2到付")
    private Integer expressType;
    @ApiModelProperty(value = "订单状态 0待付款 1已付款 2已关闭 3正在退款 4已退款 5待关闭 6部分退款")
    private Integer status;
    @ApiModelProperty(value = "场次ID")
    private String timeId;
    @ApiModelProperty(value = "票种ID")
    private String ticketId;
    @ApiModelProperty(value = "场地名称")
    private String fieldName;
    @ApiModelProperty(value = "是否实名")
    private Integer isTrueName;
    @ApiModelProperty(value = "入场人退款情况")
    private List<KylinOrderTicketEntitiesPreRefundVo> entitiesPreRefundVos;
    @ApiModelProperty(value = "收货人")
    private String expressContacts;
    @ApiModelProperty(value = "收货地址")
    private String expressAddress;
    @ApiModelProperty(value = "收货人联系方式")
    private String expressPhone;

    @ApiModelProperty(value = "演出ID")
    private String performanceId;
    @ApiModelProperty(position = 14, value = "演出名称")
    private String performanceTitle;
    @ApiModelProperty(value = "票种名称")
    private String ticketTitle;
    @ApiModelProperty(value = "演出开始时间")
    private String timeStart;
    @ApiModelProperty(value = "演出结束时间")
    private String useStart;
    @ApiModelProperty(value = "演出图片")
    private String performanceImg;
    @ApiModelProperty(value = "是否开启退款手续费 0关闭 1开启")
    private Integer isRefundPoundage;
    @ApiModelProperty(value = "是否开启是否退优惠券 0关闭 1开启")
    private Integer isRefundVoucher;
    @ApiModelProperty(value = "isRefundExpress 1用户承担 0无")
    private Integer isRefundExpress;

    @ApiModelProperty(value = "手续费规则列表")
    private ArrayList<OrderRefundPoundage> refundPoundageList;
    @ApiModelProperty(value = "订单使用优惠券列表")
    private ArrayList<KylinOrderCoupons> orderCouponList;
    @ApiModelProperty(value = "退款快递统一寄回地址")
    private OrderRefundAddress refundAddress;

    private static final KylinOrderTicketPreVo obj = new KylinOrderTicketPreVo();

    public static KylinOrderTicketPreVo getNew() {
        try {
            return (KylinOrderTicketPreVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new KylinOrderTicketPreVo();
        }
    }
}
