package com.liquidnet.service.kylin.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.github.pagehelper.PageInfo;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PayAgainParam;
import com.liquidnet.service.kylin.dto.param.PayOrderParam;
import com.liquidnet.service.kylin.dto.param.SyncOrderParam;
import com.liquidnet.service.kylin.dto.vo.KylinOrderListVo;
import com.liquidnet.service.kylin.dto.vo.OrderDetailsVo;
import com.liquidnet.service.kylin.dto.vo.PayResultVo;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;

import java.util.List;

/**
 * <p>
 * 订单 服务类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-20
 */
public interface IKylinOrderTicketsService extends IService<KylinOrderTickets> {

    // 下单前判断接口(判断是否可锁定库存)(无订单->待支付->可支付)
    ResponseDto<PayResultVo> checkCanOrder(PayOrderParam payOrderParam);

    // 再次支付(待支付->可支付->倒计时结束释放库存)
    ResponseDto<PayResultVo> payAgain(PayAgainParam payAgainParam);

    // 支付回调(待支付->已支付->中断倒计时)
    String syncOrder(SyncOrderParam syncOrderParam);

    // 同步大麦数据接口

    //订单列表(状态 待支付 已支付 倒计时 已失效)
    PageInfo<List<KylinOrderListVo>> orderList(int page, int size);

    //订单详情
    OrderDetailsVo orderDetails(String orderId);

    //TASK 倒计时
    boolean checkOrderTime(String userId);

    //TASK 订单状态
    ResponseDto<Integer> checkOrderResult(String orderId);


    // 下单接口(无订单->待支付->可支付)
    // 删除订单
    // 代理票务 可买状态判断
    // 取消支付(待支付->订单失效->释放库存->中断倒计时)
    // ResponseDto<PayResultVo> order(PayOrderParam payOrderParam, String uid, boolean isMember, int isTrueName, KylinPerformanceVo performanceData, KylinTicketVo ticketData,Object adamEntersList);

}
