package com.liquidnet.commons.lang.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

import java.util.Date;
import java.util.Map;

//@Component
public class JwtUtil {
    /**
     * 过期时间15分钟
     */
    private static final long EXPIRE_TIME = 15 * 60 * 1000;
    /**
     * token私钥
     */
    private static final String TOKEN_SECRET = "DD5654D654DSD5S1D65S4D65S1D12354";

    /**
     * 用户登录成功后生成Jwt token
     * 使用Hs256算法
     *
     * @param claims 保存在Payload（有效载荷）中的内容
     * @return token字符串
     */
    public static String create(Map<String, Object> claims) {
        long nowMillis = System.currentTimeMillis();
        long expMillis = System.currentTimeMillis() + EXPIRE_TIME;

        // 创建一个JwtBuilder，设置jwt的body
        JwtBuilder builder = Jwts.builder()
                // 保存在Payload（有效载荷）中的内容, 自定义一些数据保存在这里
                .setClaims(claims)
                // iat: jwt的签发时间
                .setIssuedAt(new Date(nowMillis))
                // 设置过期时间
                .setExpiration(new Date(expMillis))
                // 使用HS256算法和签名使用的秘钥生成密文
                .signWith(SignatureAlgorithm.HS256, TOKEN_SECRET);
        return builder.compact();
    }

    /**
     * 解析token，获取到Payload（有效载荷）中的内容，包括验证签名，判断是否过期
     *
     * @param token 令牌
     * @return
     */
    public static Claims parse(String token) {
        // 得到DefaultJwtParser
        return Jwts.parser()
                // 设置签名的秘钥
                .setSigningKey(TOKEN_SECRET)
                // 设置需要解析的token
                .parseClaimsJws(token).getBody();
    }
}
