package com.liquidnet.service.adam.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.liquidnet.service.adam.entity.AdamMemberPrice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberPriceParam", description = "添加编辑会员价格")
@Data
public class AdamMemberPriceParam implements Serializable {

    private static final long serialVersionUID = 5940725094369061032L;

    @ApiModelProperty(position = 0, required = false, value = "价格id")
    private Integer mid;

    /**
     * 会员价格ID
     */
    @ApiModelProperty(position = 1, required = false, value = "会员价格ID")
    private String memberPriceId;

    /**
     * 会员类型ID
     */
    @ApiModelProperty(position = 2, required = false, value = "会员类型ID")
    private String memberId;

    /**
     * 状态  0 不可用 1上线中 2已下线
     */
    @ApiModelProperty(position = 3, required = false, value = "状态0 不可用 1上线中 2已下线", allowableValues = "0,1,2")
    private Integer status;

    /**
     * 会员包名称
     */
    @ApiModelProperty(position = 4, required = false, value = "会员价格包名称", example = "年卡")
    private String name;

    /**
     * 原价
     */
    @ApiModelProperty(position = 5, required = false, value = "原价", example = "199")
    private BigDecimal price;

    /**
     * 折扣价
     */
    @ApiModelProperty(position = 6, required = false, value = "折扣价", example = "199")
    private BigDecimal price_fixed;

    /**
     * 会员包有效天数
     */
    @ApiModelProperty(position = 7, required = false, value = "会员包有效天数", example = "365")
    private Integer days;

    /**
     * 会员包须知
     */
    @ApiModelProperty(position = 8, required = false, value = "会员包须知", example = "会员包须知")
    private String detail;

    /**
     * 创建时间
     */
    @ApiModelProperty(position = 9, required = false, value = "创建时间", example = "2021-05-10 13:13:13")
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    @ApiModelProperty(position = 10, required = false, value = "更新时间", example = "2021-05-10 13:13:13")
    private LocalDateTime updatedAt;
}
