package com.liquidnet.service.adam.service.impl.admin;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberCodeVo;
import com.liquidnet.service.adam.entity.AdamMemberCode;
import com.liquidnet.service.adam.mapper.AdamMemberCodeMapper;
import com.liquidnet.service.adam.service.IAdamUserMemberService;
import com.liquidnet.service.adam.service.admin.IAdamMemberCodeAdminService;
import com.liquidnet.service.adam.util.MemberUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Slf4j
@Service
public class AdamMemberCodeAdminServiceImpl extends ServiceImpl<AdamMemberCodeMapper, AdamMemberCode> implements IAdamMemberCodeAdminService {
    @Autowired
    AdamMemberCodeMapper adamMemberCodeMapper;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    IAdamUserMemberService adamUserMemberService;

    @Override
    public String createGiftCode(AdamMemberCodeParam param) {
        // 需要主动生成会员编号
        String memberNo = adamUserMemberService.getNextMemberNo(param.getMemberId());

        if (StringUtils.isEmpty(memberNo)) return "";

        AdamMemberCode initMemberCode = new AdamMemberCode();
        initMemberCode.setCode(MemberUtil.freeCode());
        initMemberCode.setType(param.getType());
        initMemberCode.setMemberId(param.getMemberId());
        initMemberCode.setMemberPriceId(param.getMemberPriceId());
        initMemberCode.setMemberNo(memberNo);
        initMemberCode.setState(0);// 0-未使用,1-已使用,2-不可用

        adamMemberCodeMapper.insert(initMemberCode);

        mongoTemplate.insert(AdamMemberCodeVo.getNew().copy(initMemberCode), AdamMemberCodeVo.class.getSimpleName());

        return initMemberCode.getCode();
    }
}
