package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 正在现场服务号关注事件储存用户信息表
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-05
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetWechatUsers implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * wechat_user_id
     */
    private String wechatUserId;

    /**
     * 服务类型 1正在 2摩登
     */
    private Integer type;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 性别
     */
    private String sexDesc;

    /**
     * 性别 男1
     */
    private Integer sex;

    /**
     * 头像
     */
    private String headImgUrl;

    /**
     * zh_CN
     */
    private String language;

    /**
     * 国家
     */
    private String country;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 关注时间
     */
    private LocalDateTime subscribeTime;

    /**
     * ADD_SCENE_SEARCH 关注方式
     */
    private String subscribeScene;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;


}
