package com.liquidnet.service.sweet.dto.param.admin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * SweetIntegralActivityDrawListSearchParam
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-22
 */

@Data
@ApiModel(value = "SweetIntegralActivityDrawListSearchParam", description = "积分活动中奖列表搜索入参")
public class SweetIntegralActivityDrawListSearchParam implements Serializable {

    private static final long serialVersionUID = 1309409469948421735L;

    @ApiModelProperty(value = "integralActivityId", example = "0")
    private String integralActivityId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品类型")
    private Integer prizeType;

    @ApiModelProperty(value = "用户昵称")
    private String nickname;

    @ApiModelProperty(value = "发放状态")
    private Integer receivingStatus;

    @ApiModelProperty(value = "是否中奖")
    private Integer isWin;

    @ApiModelProperty(value = "页数", example = "0")
    private Integer pageSize;

    @ApiModelProperty(value = "数量", example = "20")
    private Integer pageNum;

}
