package com.liquidnet.service.galaxy.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyArtSeriesClaimReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 11:10
 */
@ApiModel(value = "GalaxyArtSeriesClaimReqDto", description = "NFT系列声明")
@Data
public class GalaxyArtSeriesClaimReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * skuId
     */
    private String skuId;
    /**
     * 系列一共有多少个，0表示没有限制
     */
    private Long totalCount;
    /**
     * 系列封面url，不超过1024个字符
     */
    private String coverUrl;
    /**
     * 系列描述信息，不超过500个字符
     */
    private String desc;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyArtSeriesClaimReqDto obj = new GalaxyArtSeriesClaimReqDto();

    public static GalaxyArtSeriesClaimReqDto getNew() {
        try {
            return (GalaxyArtSeriesClaimReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyArtSeriesClaimReqDto();
        }
    }
}
