package com.liquidnet.service.galaxy.dto;

import com.liquidnet.commons.lang.util.JsonUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Digits;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: NFT购买(涉及NFT发行、NFT购买)
 * @class: GalaxyNftBuyReqDto
 * @Package com.liquidnet.service.galaxy.dto
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/14 18:13
 */
@ApiModel(value = "GalaxyNftBuyReqDto", description = "NFT购买")
@Data
public class GalaxyNftBuyReqDto extends GalaxyBaseReqDto implements Serializable,Cloneable {
    /**
     * 以下为发行参数***********************************
     */
    @ApiModelProperty(position = 1, required = true, value = "用户ID[30]")
    @NotBlank(message = "用户ID不能为空！")
    @Size(min = 1, max = 30, message = "用户ID限制2-30位且不能包含特殊字符")
    private String userId;
    /**
     * skuId
     */
    @ApiModelProperty(position = 1, required = true, value = "系列唯一id标识，不超过20个字符")
    @Size(min = 2, max = 20, message = "skuId限制2-20位且不能包含特殊字符")
    private String skuId;
    /**
     * 作者名，中文+英文(数字或符号为非法输入) 不超过30个字符
     */
    @ApiModelProperty(position = 1, required = true, value = "作者名，中文+英文(数字或符号为非法输入) 不超过20个字符")
    @Size(max = 20, message = "中文+英文(数字或符号为非法输入) 不超过20个字符")
    private String author;

    /**
     * nft名字(sku名称)，中英文数字均可，不超过256个字符
     */
    @ApiModelProperty(position = 1, required = true, value = "nft名字(sku名称)，中英文数字均可，不超过100个字符")
    @Size(max = 100, message = "nft名字不能超过100个字符")
    private String name;
    /**
     * nftUrl，不超过1024个字符
     */
    @ApiModelProperty(position = 1, required = true, value = "nftUrl，不超过500个字符")
    @Size(max = 500, message = "nftUrl，不超过500个字符")
    private String url;
    /**
     * 预览图url，不超过1024个字符。(至信链浏览器展示预览图尺寸为290*290，请上传比例为1:1的图片)
     */
    @ApiModelProperty(position = 1, required = true, value = "预览图url，不超过500个字符")
    @Size(max = 500, message = "预览图url，不超过500个字符")
    private String displayUrl;
    /**
     * nft简介，500个字符以内
     */
    @ApiModelProperty(position = 1, required = true, value = "nft简介，300个字符以内")
    @Size(max = 300, message = "nft简介，300个字符以内")
    private String desc;
    /**
     * 标签，【文创】，游戏，动漫，30个字符以内
     * 非必填
     */
    @ApiModelProperty(position = 1, required = false, value = "标签，文创，游戏，动漫，30个字符以内")
    @Size(max = 20, message = "标签，文创，游戏，动漫，20个字符以内")
    private String flag;
    /**
     * 可售状态下有意义，表示售卖多少积分
     */
    @ApiModelProperty(position = 1, required = true, value = "sku价格，金额必须是数字格式，例：211.23 后续不可修改")
    @Digits(integer = 10,fraction = 2,message = "金额必须是数字格式")
    private String sellCount;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftBuyReqDto obj = new GalaxyNftBuyReqDto();

    public static GalaxyNftBuyReqDto getNew() {
        try {
            return (GalaxyNftBuyReqDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftBuyReqDto();
        }
    }
}
