package com.liquidnet.service.galaxy.router.strategy;

import com.liquidnet.service.galaxy.router.strategy.annotation.StrategyGalaxyRouterHandler;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyRouterStrategyListener
 * @Package com.liquidnet.service.galaxy.router.strategy
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/8 11:26
 */
@Component
public class GalaxyRouterStrategyListener  implements ApplicationListener<ContextRefreshedEvent> {
    @Override
    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map<String, Object> beans = event.getApplicationContext().getBeansWithAnnotation(StrategyGalaxyRouterHandler.class);
        GalaxyRouterStrategyContext strategyContext = event.getApplicationContext().getBean(GalaxyRouterStrategyContext.class);
        beans.forEach((name, bean) -> {
            StrategyGalaxyRouterHandler typeHandler = bean.getClass().getAnnotation(StrategyGalaxyRouterHandler.class);
            strategyContext.putStrategy(typeHandler.value().getCode(), (IGalaxyRouterStrategy) bean);
        });
    }
}
