package com.liquidnet.service.zxlnft;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.constant.ZxlnftEnum;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.io.File;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: TestZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.test
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 13:49
 */
@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
@SpringBootTest
public class TestZxlnftSdkUtil {
    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

//    private static String zhouhuanPubKey = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAERAYCoqlcb1/C+b085HO4RWbIFx/n\nw6zkU3tvIYhBi1Xjj7GMdE/dR6D2fCQGWHqdYwQUb6/kS67Yjx47prxREg==\n-----END PUBLIC KEY-----\n";
//    private static String zhouhuanPriKey = "-----BEGIN PRIVATE KEY-----\nMIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgjSDapAU4gujWk9mM\nCE1tOokocdKrHMkfvZ0vfaWM+MOgCgYIKoEcz1UBgi2hRANCAAREBgKiqVxvX8L5\nvTzkc7hFZsgXH+fDrORTe28hiEGLVeOPsYx0T91HoPZ8JAZYep1jBBRvr+RLrtiP\nHjumvFES\n-----END PRIVATE KEY-----\n";

    private static String zhouhuanPubKey1 = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAERAYCoqlcb1/C+b085HO4RWbIFx/n\nw6zkU3tvIYhBi1Xjj7GMdE/dR6D2fCQGWHqdYwQUb6/kS67Yjx47prxREg==\n-----END PUBLIC KEY-----\n";
    private static String zhouhuanPriKey1 = "-----BEGIN PRIVATE KEY-----\nMIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgjSDapAU4gujWk9mM\nCE1tOokocdKrHMkfvZ0vfaWM+MOgCgYIKoEcz1UBgi2hRANCAAREBgKiqVxvX8L5\nvTzkc7hFZsgXH+fDrORTe28hiEGLVeOPsYx0T91HoPZ8JAZYep1jBBRvr+RLrtiP\nHjumvFES\n-----END PRIVATE KEY-----\n";
    private static String zhouhuanPubKey2 = "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAELZtnP30dbtdFrvherJxfpPEQP+q3\nRyrtECAuEwZg3o8/RLJva0O6unNLHGavkwd77l5UgvX4cPNoX/OV6n/3xQ==\n-----END PUBLIC KEY-----\n";
    private static String zhouhuanPriKey2 = "-----BEGIN PRIVATE KEY-----\nMIGTAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBHkwdwIBAQQgNBYWsObyiuXLIZZZ\nPa0P/aNSrlf3//TLkdhZsDroRNugCgYIKoEcz1UBgi2hRANCAAQtm2c/fR1u10Wu\n+F6snF+k8RA/6rdHKu0QIC4TBmDejz9Esm9rQ7q6c0scZq+TB3vuXlSC9fhw82hf\n85Xqf/fF\n-----END PRIVATE KEY-----\n";
    private static String zhouhuanAddress1 = "zxf8dcce2b5374610631735ad4d606372ff199d89e";
    private static String zhouhuanAddress2 = "zx26ff9db9cf1e981e3028b7e133d54b28eb859f97";
    private static String ID_CARD_1 = "142323198302062216";
    private static String ID_CARD_2 = "150422199805206019";


    @Test
    public void nft001RegisterVerifyCode(){
        Nft001RegisterVerifyCodeReqDto reqDto = Nft001RegisterVerifyCodeReqDto.getNew();
        reqDto.setMobile("13811314082");
        ZxlnftResponseDto<Nft001RegisterVerifyCodeRespDto> resp = zxlnftSdkUtil.nft001RegisterVerifyCode(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft002RegisterPerson(){
        Nft002RegisterPersonReqDto reqDto = Nft002RegisterPersonReqDto.getNew();
        reqDto.setPersonName("安家宾");
//        reqDto.setEmail("");
        reqDto.setMobile("13811314082");
        reqDto.setVerifyCode("669340");
        reqDto.setIdCard(ID_CARD_1);
        reqDto.setCardType(Integer.valueOf(ZxlnftEnum.CardTypeEnum.ID_CARD.getCode()));
        ZxlnftResponseDto<Nft002RegisterPersonRespDto> resp = zxlnftSdkUtil.nft002RegisterPerson(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft003RegisterPersonPlatform(){
        Nft003RegisterPersonPlatformReqDto reqDto = Nft003RegisterPersonPlatformReqDto.getNew();
        // userIdentification  68c8e0af922c450e35316977548971a1e5c335b1f5a4e21133257f0749b5c0a2
        //                     68c8e0af922c450e35316977548971a1e5c335b1f5a4e21133257f0749b5c0a2
        reqDto.setPersonName("安家宾");
//        reqDto.setEmail("");
        reqDto.setMobile("13811314082");
        reqDto.setIdCard(ID_CARD_1);

//        reqDto.setPersonName("周焕");
////        reqDto.setEmail("");
//        reqDto.setMobile("18548596019");
//        reqDto.setIdCard("150422199805206019");

        reqDto.setCardType(Integer.valueOf(ZxlnftEnum.CardTypeEnum.ID_CARD.getCode()));
        ZxlnftResponseDto<Nft003RegisterPersonPlatformRespDto> resp = zxlnftSdkUtil.nft003RegisterPersonPlatform(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft004BusinessLicenseUpload(){
        Nft004BusinessLicenseUploadReqDto reqDto = Nft004BusinessLicenseUploadReqDto.getNew();
        reqDto.setFile(new File("/Users/anjiabin/Downloads/zxl_image_test_001.jpg"));
        reqDto.setMobile("13811314082");
        reqDto.setVerifyCode("123456");
        ZxlnftResponseDto<Nft004BusinessLicenseUploadRespDto> resp = zxlnftSdkUtil.nft004BusinessLicenseUpload(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft005BusinessLicenseUploadPlatform(){
        Nft005BusinessLicenseUploadPlatformReqDto reqDto = Nft005BusinessLicenseUploadPlatformReqDto.getNew();
        reqDto.setFile(new File("/Users/anjiabin/Downloads/zxl_image_test_001.jpg"));
        ZxlnftResponseDto<Nft005BusinessLicenseUploadPlatformRespDto> resp = zxlnftSdkUtil.nft005BusinessLicenseUploadPlatform(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft006OfficialLetterUpload(){
        Nft006OfficialLetterUploadReqDto reqDto = Nft006OfficialLetterUploadReqDto.getNew();
        reqDto.setFile(new File("/Users/anjiabin/Downloads/zxl_image_test_001.jpg"));
        reqDto.setMobile("13811314082");
        reqDto.setVerifyCode("123456");
        ZxlnftResponseDto<Nft006OfficialLetterUploadRespDto> resp = zxlnftSdkUtil.nft006OfficialLetterUpload(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft007OfficialLetterUploadPlatform(){
        Nft007OfficialLetterUploadPlatformReqDto reqDto = Nft007OfficialLetterUploadPlatformReqDto.getNew();
        reqDto.setFile(new File("/Users/anjiabin/Downloads/zxl_image_test_001.jpg"));
        ZxlnftResponseDto<Nft007OfficialLetterUploadPlatformRespDto> resp = zxlnftSdkUtil.nft007OfficialLetterUploadPlatform(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft008QueryImageModeration(){
        Nft008QueryImageModerationReqDto reqDto = Nft008QueryImageModerationReqDto.getNew();
        reqDto.setImageUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
//        reqDto.setIntrval(0);
//        reqDto.setMaxFrames(1);
        ZxlnftResponseDto<Nft008QueryImageModerationRespDto> resp = zxlnftSdkUtil.nft008QueryImageModeration(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft009RegisterCompany(){
        Nft009RegisterCompanyReqDto reqDto = Nft009RegisterCompanyReqDto.getNew();
        reqDto.setEpName("企业名称");
//        reqDto.setEmail();
        reqDto.setVerifyCode("325588");
//        reqDto.setCreditCode("91110101330367841P");
        reqDto.setCreditCode("91110101330367841P");
        reqDto.setBusiLicenseId(12222);
//        reqDto.setOfficialLetterId();
        reqDto.setRepresentativeName("沈总");
        reqDto.setContact("安家宾");
        reqDto.setMobile("13811314082");
        reqDto.setIdcard(ID_CARD_1);
        reqDto.setCardType(Integer.parseInt(ZxlnftEnum.CardTypeEnum.ID_CARD.getCode()));
//        reqDto.setPlatformName();c
//        reqDto.setPlatformUrl();
//        reqDto.setBusinessType();

        ZxlnftResponseDto<Nft009RegisterCompanyRespDto> resp = zxlnftSdkUtil.nft009RegisterCompany(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft010RegisterCompanyPlatform(){
        Nft010RegisterCompanyPlatformReqDto reqDto = Nft010RegisterCompanyPlatformReqDto.getNew();
        reqDto.setEpName("北京正在映画互联网科技有限公司");
//        reqDto.setEmail();
        reqDto.setCreditCode("91110101330367841P");
        reqDto.setBusiLicenseId(12222);
//        reqDto.setOfficialLetterId();
        reqDto.setRepresentativeName("沈总");
        reqDto.setContact("安家宾");
        reqDto.setMobile("13811314082");
        reqDto.setIdcard(ID_CARD_1);
        reqDto.setCardType(Integer.parseInt(ZxlnftEnum.CardTypeEnum.ID_CARD.getCode()));
//        reqDto.setPlatformName();c
//        reqDto.setPlatformUrl();
//        reqDto.setBusinessType();

        ZxlnftResponseDto<Nft010RegisterCompanyPlatformRespDto> resp = zxlnftSdkUtil.nft010RegisterCompanyPlatform(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft011UserQueryVerifyCode(){
        Nft011UserQueryVerifyCodeReqDto reqDto = Nft011UserQueryVerifyCodeReqDto.getNew();
        //查询用户信息 发送手机验证码
        reqDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.COMPANY.getCode()));
        reqDto.setCardNo(ID_CARD_1);
        reqDto.setScene(Integer.valueOf(ZxlnftEnum.UseSceneEnum.QUERY.getCode()));

        //nft平台绑定地址 发送邮箱验证码
//        reqDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.PERSON.getCode()));
//        reqDto.setCardNo(ID_CARD_1);
//        reqDto.setScene(Integer.valueOf(ZxlnftEnum.UseSceneEnum.BINDING.getCode()));
        ZxlnftResponseDto<Nft011UserQueryVerifyCodeRespDto> resp = zxlnftSdkUtil.nft011UserQueryVerifyCode(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft012UserQuery(){
        Nft012UserQueryReqDto reqDto = Nft012UserQueryReqDto.getNew();
        reqDto.setType(Integer.valueOf(ZxlnftEnum.RegisterTypeEnum.COMPANY.getCode()));
        reqDto.setCardNo(ID_CARD_1);
        reqDto.setVerifyCode("045029");
        ZxlnftResponseDto<Nft012UserQueryRespDto> resp = zxlnftSdkUtil.nft012UserQuery(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft013IdentityBindSubmit(){
        Nft013IdentityBindSubmitReqDto reqDto = Nft013IdentityBindSubmitReqDto.getNew();
        reqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        reqDto.setUserIdentification("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef");
        reqDto.setSignData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),reqDto.getUserIdentification()));
        reqDto.setFaceResultId("122");
        ZxlnftResponseDto<Nft013IdentityBindSubmitRespDto> resp = zxlnftSdkUtil.nft013IdentityBindSubmit(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft014IdentityBindSubmitByTrusted(){
        Nft014IdentityBindSubmitByTrustedReqDto reqDto = Nft014IdentityBindSubmitByTrustedReqDto.getNew();
        //安家宾
        reqDto.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());
        reqDto.setUserIdentification("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef");
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),reqDto.getUserIdentification());

        //周焕
        reqDto.setUserPubKey(zhouhuanPubKey1);
        reqDto.setUserIdentification("0354415fabf861ecde70db198836bf82af025820ea50f66c05589e21b6d9700f");
        signature = zxlnftBiz.createSign(zhouhuanPriKey1,reqDto.getUserIdentification());

        reqDto.setUserSignData(signature);
        ZxlnftResponseDto<Nft014IdentityBindSubmitByTrustedRespDto> resp = zxlnftSdkUtil.nft014IdentityBindSubmitByTrusted(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft015IdentityBindPlatformSelf(){
        Nft015IdentityBindPlatformSelfReqDto reqDto = Nft015IdentityBindPlatformSelfReqDto.getNew();
        reqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        reqDto.setUserIdentification("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef");
        reqDto.setVerifyCode("061628");
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),reqDto.getUserIdentification());
        reqDto.setSignData(signature);
        ZxlnftResponseDto<Nft015IdentityBindPlatformSelfRespDto> resp = zxlnftSdkUtil.nft015IdentityBindPlatformSelf(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft016IdentityBindQuery(){
        Nft016IdentityBindQueryReqDto reqDto = Nft016IdentityBindQueryReqDto.getNew();
//        reqDto.setAddressList("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        reqDto.setAddressList("ZXfa63b4ff148dbebb6ed9c185a5f7f8b8fdcf90ad");
        ZxlnftResponseDto<Nft016IdentityBindQueryRespDto> resp = zxlnftSdkUtil.nft016IdentityBindQuery(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft017IdentityVerifyIdentity(){
        Nft017IdentityVerifyIdentityReqDto reqDto = Nft017IdentityVerifyIdentityReqDto.getNew();
        reqDto.setAddress("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        reqDto.setAddress("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        reqDto.setFaceResultId("111");
        ZxlnftResponseDto<Nft017IdentityVerifyIdentityRespDto> resp = zxlnftSdkUtil.nft017IdentityVerifyIdentity(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 18	请求人脸核身h5url	api/v1/nft/face/url
     * 19	通过用户地址请求人脸核身h5url	api/v1/nft/face/url_by_address
     * 20	人身核对结果查询接口	api/v1/nft/face/query
     */

    @Test
    public void nft021UploadUrl(){
        Nft021UploadUrlReqDto reqDto = Nft021UploadUrlReqDto.getNew();
        reqDto.setSeriesName("NOW_ZXL_NFT_PIC001_test_skuId001");
        reqDto.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
        reqDto.setUserIdentification(zxlnftConfig.getPlatformIdentification()); //暂时素材上传人和平台管理员是同一个人
        ZxlnftResponseDto<Nft021UploadUrlRespDto> resp = zxlnftSdkUtil.nft021UploadUrl(reqDto);
        System.out.println(resp.toJson());

//        {
//            "code": "0",
//                "data": {
//            "materialAddress": "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/"
//        },
//            "success": true
//        }
    }

    @Test
    public void nft022UploadSecret(){
        Nft022UploadSecretReqDto reqDto = Nft022UploadSecretReqDto.getNew();
        reqDto.setSeriesName("NOW_ZXL_NFT_PIC001_test_skuId001");
        reqDto.setTimestamp(DateUtil.getNowSeconds().toString());
        reqDto.setUserPubKey(zxlnftConfig.getNftPlatformPubKey());

        //系列为空
        String userData = reqDto.getTimestamp();
        //系列不为空
        if(StringUtil.isNotEmpty(reqDto.getSeriesName())){
            userData = reqDto.getTimestamp() + "_" + reqDto.getSeriesName();
        }

        reqDto.setUserSignedData(zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),userData));

        ZxlnftResponseDto<Nft022UploadSecretRespDto> resp = zxlnftSdkUtil.nft022UploadSecret(reqDto);
        System.out.println(resp.toJson());

        //为什了发行人和平台是同一个人时，uploadAddres会少一级目录 少了个人目录，是自动省略了吗？
//        {
//            "code": "0",
//             "data": {
//                     "tempSecretId": "AKIDhhEkTGgB37L_rc-Wy6sfqvz70a1AspdRh11oawassCa6Rg2SZ-V7Z-x66cGtRpOO",
//                    "tempSecretKey": "2KZKWE/BfzgbHoCYTTihLJW2QyVm4Bz48gsD1uPLvJg=",
//                    "sessionToken": "kgtsbjIKkVgYlIEGTZRJ1NJ3UhadM7Ea1eff3b33758e079d44b6fe4fd1f60e47ug5Dj85tZJxxa9efvA0xBWj6fZWagnsEzf25ZSGsEJrjjEY8ydKuIQrUuIjW9ifGHC1BYQ9kChXrSyXxHKO9O2RD4qDa-g3ljhBAbChtFyMCLxZKCG9OKpmB3yyRnF9mb-D5CHTDhO7ubUap_tIldEyqkWxmvfrvHgF0ndnhRt_I444-YQxnroHEnEk4gcBkRdDTeI_9JhVhQy3LZoBflfW1h0ZOHk2O1U7JrnsS7t5hOdjfXIul142mimp2YsDifJc8j2U5uAlml37iNqZ1OFsvxVcbPSI8dWCOiZvRk3ndN9EDEXDZjgrr-1nC3j1ZdXXE5ii1DCWbfmvhWFBbJit6PGqO7M-95Zuw-6VkzX5vwNaYMqtcU_a7u3brFu1DihZHxcjt3O6avzjaU_su6t_98G0DzL_CjvR_fLFKCpI3f3OhGC8jFm6D10cGYadwW7uQ10waXgMs11xjsgiC-By2K4G5xNa36t11wuXxISzJg5-v_eLCXQue8YXwZJNN2e49CdK2trGEwtB8z0Ok6HnlXK68fSCk0PDcmo1MhP18kCDC3Cm_LgbOQGExpuTDPc_HKlUZn9xBVJWqqiySE05aFSs8nr6WLlce5lzFbhIY_yJLMprZNNg8azBK_bgiyEJWavf3Kt8KRAo0YEMs8R0Cuma5YLsCzzCN6vBkW_hWfqZceT_BAcrP3p_-4IPtj7LtbfbhrhnfcUtfC2BoJiBIQXFPita4QrKwpkKVW5SyDw6O2zh0Iam7DjdXlKFrdH8nJef3oRYEqLsS_MOMU29kNRIxLfcrsXw_jTQ1Bjs",
//                    "uploadAddress": "https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/NOW_ZXL_NFT_PIC001_test_skuId001/"
//            },
//            "success": true
//        }
    }

    @Test
    public void nft023PointApply(){
        Nft023PointApplyReqDto reqDto = Nft023PointApplyReqDto.getNew();
        //安家宾
//        reqDto.setApplyerAddr("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        //周焕1
//        reqDto.setApplyerAddr("ZXf8dcce2b5374610631735ad4d606372ff199d89e");
        //周焕2
        reqDto.setApplyerAddr("ZX26ff9db9cf1e981e3028b7e133d54b28eb859f97");
        reqDto.setCount(200l);
        reqDto.setOperateId(IDGenerator.get32UUID());
        ZxlnftResponseDto<Nft023PointApplyRespDto> resp = zxlnftSdkUtil.nft023PointApply(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 查询失败
     */
    @Test
    public void nft024PointApplyResult(){
        Nft024PointApplyResultReqDto reqDto = Nft024PointApplyResultReqDto.getNew();
        reqDto.setTaskId("337fe5cc-d509-418f-867f-378ca351e4ba_apply-point_1");
        reqDto.setTaskId("01e01f1c-93c8-4bb0-b0f5-1ff064c210dc_apply-point_1");
        reqDto.setTaskId("d1de1627-fcc6-46a2-8540-e4bd17ac1a02_apply-point_1");
        reqDto.setTaskId("a09a628e-13c5-4183-a528-3bf9b3123fb7_apply-point_1");
        ZxlnftResponseDto<Nft024PointApplyResultRespDto> resp = zxlnftSdkUtil.nft024PointApplyResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 25	平台积分转移	api/v1/nft/point/transfer
     * 26	平台积分转移状态查询	api/v1/nft/point/transfer/result
     * 27	积分销毁	api/v1/nft/point/destroy
     * 28	查询积分销毁结果	api/v1/nft/point/destory/resul
     */

    @Test
    public void nft029PointQuery(){
        Nft029PointQueryReqDto reqDto = Nft029PointQueryReqDto.getNew();
        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
        //周焕1
//        reqDto.setAddr(zhouhuanAddress1);
        //周焕2
//        reqDto.setAddr(zhouhuanAddress2);
        ZxlnftResponseDto<Nft029PointQueryRespDto> resp = zxlnftSdkUtil.nft029PointQuery(reqDto);
        System.out.println(resp.toJson());
    }
//30	NFT 系列声明	api/v1/nft/series/claim
//31	查询NFT系列声明结果	api/v1/nft/series/claim/result
//32	查询系列信息	api/v1/nft/series
//33	查询该账户资产归属的系列列表	api/v1/nft/series/list

    @Test
    public void nft030SeriesClaim(){
//        Nft030SeriesClaimReqDto reqDto = Nft030SeriesClaimReqDto.getNew();
//        reqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
//        reqDto.setSeriesName("北京草莓音乐节2022主题模型-系列002");
//        reqDto.setTotalCount(10l);
//        reqDto.setOperateId(IDGenerator.get32UUID());
//        reqDto.setCoverUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
//        reqDto.setDesc("系列描述信息不超过500字符");
//        reqDto.setMaxPublishCount(0);
//        reqDto.setSeriesBeginFromZero(false);

        //无限制系列
        Nft030SeriesClaimReqDto reqDto = Nft030SeriesClaimReqDto.getNew();
        reqDto.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        reqDto.setSeriesName("北京草莓音乐节2022主题模型-系列000");
        reqDto.setTotalCount(0l);
        reqDto.setOperateId(IDGenerator.get32UUID());
        reqDto.setCoverUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDesc("系列描述信息不超过500字符");
        reqDto.setMaxPublishCount(0);
        reqDto.setSeriesBeginFromZero(false);

        ZxlnftResponseDto<Nft030SeriesClaimRespDto> resp = zxlnftSdkUtil.nft030SeriesClaim(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft031SeriesClaimResult(){
        Nft031SeriesClaimResultReqDto reqDto = Nft031SeriesClaimResultReqDto.getNew();
        //第零个系列 无限制系列
        reqDto.setTaskId("e1788c18-f72b-4dc3-8394-1c5f90d8aea6_nft-series-claim_1");
        //第一个系列 北京草莓音乐节2022主题模型-系列001
//        reqDto.setTaskId("dc92bbd6-eb95-4452-99f8-0726001367be_nft-series-claim_1");
        //第二个系列 北京草莓音乐节2022主题模型-系列002
//        reqDto.setTaskId("0d951a6b-0697-4ede-83f2-e31485f380ce_nft-series-claim_1");

        ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> resp = zxlnftSdkUtil.nft031SeriesClaimResult(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft032Series(){
        Nft032SeriesReqDto reqDto = Nft032SeriesReqDto.getNew();
        //第零个系列 无限制系列查询
//        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_8a827e181b695fb8d9b081d3855d2895ced1d003ee186622a005cec37ea77e59");
        //第一个系列
        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_ca49b5ebadd5f73ab057fe869bf897cbcc0f31e0b89db71cc3ec78bca2d16ed6");
        //第二个系列
//        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_31ff9f7d4c33c98518e095fec6cecdab8d337751602cf6e651eb7d131cff5b61");
        ZxlnftResponseDto<Nft032SeriesRespDto> resp = zxlnftSdkUtil.nft032Series(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft033SeriesList(){
        Nft033SeriesListReqDto reqDto = Nft033SeriesListReqDto.getNew();
        reqDto.setAddr("ZXa66c8a684727d0f9aaa434044362aa8a18b61bb4");
        ZxlnftResponseDto<Nft033SeriesListRespDto> resp = zxlnftSdkUtil.nft033SeriesList(reqDto);
        System.out.println(resp.toJson());
    }


    @Test
    public void nft034Publish(){
//        Nft034PublishReqDto reqDto = Nft034PublishReqDto.getNew();
//        reqDto.setAuthor("正在现场创作者001");
//        reqDto.setName("北京2022草莓音乐节2022");
//        reqDto.setUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
//        reqDto.setDisplayUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
//        reqDto.setDesc("NFT描述信息");
//        reqDto.setFlag("文创");
//        reqDto.setPublishCount(1l);
////      reqDto.setSeriesId("");
//        reqDto.setSeriesBeginIndex(1);
//        reqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
//        reqDto.setSellCount(1000l);
//        reqDto.setOperateId(IDGenerator.get32UUID());
//        reqDto.setMetaData("");

        /**
         * 发行无限制系列
         */
        Nft034PublishReqDto reqDto = Nft034PublishReqDto.getNew();
        reqDto.setAuthor("正在现场创作者001");
        reqDto.setName("上海草莓音乐节2022");
        reqDto.setUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDisplayUrl("https://zhixinliantest-1302317679.cos.ap-guangzhou.myqcloud.com/nft/4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef/ZXLNFTIMAGE202202241512003609141721.jpg");
        reqDto.setDesc("NFT描述信息");
        reqDto.setFlag("文创");
        reqDto.setPublishCount(6l);
        //无限制零系列
//        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_8a827e181b695fb8d9b081d3855d2895ced1d003ee186622a005cec37ea77e59");
//        //系列001
        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_ca49b5ebadd5f73ab057fe869bf897cbcc0f31e0b89db71cc3ec78bca2d16ed6");
//        //系列002
//        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_31ff9f7d4c33c98518e095fec6cecdab8d337751602cf6e651eb7d131cff5b61");
        reqDto.setSeriesBeginIndex(6);
        reqDto.setSellStatus(Integer.parseInt(ZxlnftEnum.SellStatusEnum.CAN_SELL.getCode()));
        reqDto.setSellCount(1000l);
        reqDto.setOperateId(IDGenerator.get32UUID());
        reqDto.setMetaData("");

        ZxlnftResponseDto<Nft034PublishRespDto> resp = zxlnftSdkUtil.nft034Publish(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * NFT发行
     */
    @Test
    public void nft035PublishResult(){
        Nft035PublishResultReqDto reqDto = Nft035PublishResultReqDto.getNew();
//        reqDto.setTaskId("5d23ed47-dcb2-4672-99eb-060c04727a20_nft-publish_3");
//        reqDto.setTaskId("15ba80bb-a5f9-41db-b708-20bf4df34c14_nft-publish_3");
//        reqDto.setTaskId("1b8b94c0-e9d1-4885-97a5-ae1b82302e17_nft-publish_3");
        //无限制系列发行 1
        reqDto.setTaskId("5a53f3ea-64a5-45a2-828b-196887990696_nft-publish_3");
        //无限制系列发行 2
        reqDto.setTaskId("f87f687f-0b3c-46fa-b23b-d1bbf6c2594f_nft-publish_3");
        //北京草莓无限制系列发行 4
        reqDto.setTaskId("ee26ee9c-7005-48ca-bbc0-3e367c641dce_nft-publish_3");
        //上海草莓无限制系列发行 4 发行失败 已经存在
        reqDto.setTaskId("76087122-b417-49ce-bed6-54a106375293_nft-publish_3");
        //上海草莓无限制系列发行 5
        reqDto.setTaskId("4d208028-36af-463b-b8ce-d1ca784df7b7_nft-publish_3");
        //上海草莓无限制系列发行 6 共5个
        reqDto.setTaskId("7bb78a44-aebe-460e-9624-7914cfc6854b_nft-publish_3");
        //上海草莓无限制系列发行 11 共5个
        reqDto.setTaskId("eee6ca98-e497-43bd-969d-cdc599d0f2bd_nft-publish_3");
        //系列001  发行ID1 共5个
        reqDto.setTaskId("45ebcf2a-5d71-44fc-a7f3-f88f3c92cfe6_nft-publish_3");
        //系列001  发行ID6 共6个
        reqDto.setTaskId("2f1eae08-6b52-42ff-ac69-78cca7bf6913_nft-publish_3");
        ZxlnftResponseDto<Nft035PublishResultRespDto> resp = zxlnftSdkUtil.nft035PublishResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * NFT发行
     */
    @Test
    public void nft036Info(){
        Nft036InfoReqDto reqDto = Nft036InfoReqDto.getNew();
        reqDto.setNftId("7f73aca56caaf57a20f0afff59318528f0f09ffbf028fe882161d3ce599d2854_1");
        ZxlnftResponseDto<Nft036InfoRespDto> resp = zxlnftSdkUtil.nft036Info(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 37 查询账户NFT列表
     */
    @Test
    public void nft037AddressList(){
        Nft037AddressListReqDto reqDto = Nft037AddressListReqDto.getNew();
        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
//        reqDto.setAddr(zhouhuanAddress2);
        //系列001
        reqDto.setSeriesId("4e40d5f6f65aa8ec9bc33ab424e0167e68783bbe95d4d265086314d749808eef_ca49b5ebadd5f73ab057fe869bf897cbcc0f31e0b89db71cc3ec78bca2d16ed6");
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft037AddressListRespDto> resp = zxlnftSdkUtil.nft037AddressList(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 查询无系列NFT列表
     */
    @Test
    public void nft038AddressWithoutSeriesList(){
        Nft038AddressWithoutSeriesListReqDto reqDto = Nft038AddressWithoutSeriesListReqDto.getNew();
        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
//        reqDto.setAddr(zhouhuanAddress1);
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft038AddressWithoutSeriesListRespDto> resp = zxlnftSdkUtil.nft038AddressWithoutSeriesList(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 查询NFT交易信息列表
     */
    @Test
    public void nft039TradeList(){
        Nft039TradeListReqDto reqDto = Nft039TradeListReqDto.getNew();
        reqDto.setNftId("08c152e5fa467d28b7add8e408fb3ecd1ed2ff209364adc1e394bde53929df8f_1");
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft039TradeListRespDto> resp = zxlnftSdkUtil.nft039TradeList(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 查询转入NFT交易信息列表
     */
    @Test
    public void nft040TradeInList(){
        Nft040TradeInListReqDto reqDto = Nft040TradeInListReqDto.getNew();
//        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
        reqDto.setAddr(zhouhuanAddress2);
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft040TradeInListRespDto> resp = zxlnftSdkUtil.nft040TradeInList(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 查询转出NFT交易信息列表
     */
    @Test
    public void nft041TradeOutList(){
        Nft041TradeOutListReqDto reqDto = Nft041TradeOutListReqDto.getNew();
        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
//        reqDto.setAddr(zhouhuanAddress2);
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft041TradeOutListRespDto> resp = zxlnftSdkUtil.nft041TradeOutList(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 通过地址查询全部NFT交易信息列表
     */
    @Test
    public void nft042TradeAllList(){
        Nft042TradeAllListReqDto reqDto = Nft042TradeAllListReqDto.getNew();
//        reqDto.setAddr(zxlnftConfig.getNftPlatformAddress());
//        reqDto.setAddr(zhouhuanAddress1);
        reqDto.setAddr(zhouhuanAddress2);
//        reqDto.setOffset(0l);
        reqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft042TradeAllListRespDto> resp = zxlnftSdkUtil.nft042TradeAllList(reqDto);
        System.out.println(resp.toJson());
    }

    @Test
    public void nft043Buy(){
        Nft043BuyReqDto reqDto = Nft043BuyReqDto.getNew();
//        reqDto.setNftId("7f73aca56caaf57a20f0afff59318528f0f09ffbf028fe882161d3ce599d2854_1");
        reqDto.setNftId("08c152e5fa467d28b7add8e408fb3ecd1ed2ff209364adc1e394bde53929df8f_1");
        reqDto.setApplyScore(1000);
        reqDto.setReceiverPubKey(zhouhuanPubKey1);
        reqDto.setPointReceiverAddr(zhouhuanAddress1);
        reqDto.setOfferCount(1000l);
        reqDto.setOperateId(IDGenerator.get32UUID());

        /**
         * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
         * 接口名：buy_nft
         */
        String signMetaData = zxlnftConfig.getNftPlatformPubKey()
                .concat("_").concat(reqDto.getReceiverPubKey())
                .concat("_").concat(reqDto.getPointReceiverAddr())
                .concat("_").concat(reqDto.getApplyScore().toString())
                .concat("_").concat("buy_nft")
                .concat("_").concat(reqDto.getNftId())
                .concat("_").concat(reqDto.getOfferCount().toString())
                .concat("_").concat(reqDto.getOperateId());
        String signature = zxlnftBiz.createSign(zhouhuanPriKey1,signMetaData);
        reqDto.setSignature(signature);

        ZxlnftResponseDto<Nft043BuyRespDto> resp = zxlnftSdkUtil.nft043Buy(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * NFT发行
     */
    @Test
    public void nft044BuyResult(){
        Nft044BuyResultReqDto reqDto = Nft044BuyResultReqDto.getNew();
        reqDto.setTaskId("035137e8-f1ac-4784-a2e4-2a830878bb47_buy-nft_2");
        ZxlnftResponseDto<Nft044BuyResultRespDto> resp = zxlnftSdkUtil.nft044BuyResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * NFT发行
     */
    @Test
    public void nft045BuyPayResult(){
        Nft045BuyPayResultReqDto reqDto = Nft045BuyPayResultReqDto.getNew();
        reqDto.setTaskId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft045BuyPayResultRespDto> resp = zxlnftSdkUtil.nft045BuyPayResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 46 NFT转移
     */
    @Test
    public void nft046Transfer(){
        Nft046TransferReqDto reqDto = Nft046TransferReqDto.getNew();
        reqDto.setPubKey("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setReceiverAddr("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setNftId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setOperateId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setSignature("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft046TransferRespDto> resp = zxlnftSdkUtil.nft046Transfer(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 47 NFT同名转移
     */
    @Test
    public void nft047SelfTransfer(){
        Nft047SelfTransferReqDto reqDto = Nft047SelfTransferReqDto.getNew();
        reqDto.setPubKey("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setReceiverAddr("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setNftId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setOperateId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setSignature("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft047SelfTransferRespDto> resp = zxlnftSdkUtil.nft047SelfTransfer(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 48 NFT批量转移
     */
    @Test
    public void nft048BatchTransfer(){
        Nft048BatchTransferReqDto reqDto = Nft048BatchTransferReqDto.getNew();
        reqDto.setPubKey("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setReceiverAddr("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setNftIds("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setOperateId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setSignature("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft048BatchTransferRespDto> resp = zxlnftSdkUtil.nft048BatchTransfer(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 49 NFT转移状态查询
     */
    @Test
    public void nft049TransferResult(){
        Nft049TransferResultReqDto reqDto = Nft049TransferResultReqDto.getNew();
        reqDto.setOperatorPubKey("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setTaskId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft049TransferResultRespDto> resp = zxlnftSdkUtil.nft049TransferResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 50 NFT销售状态变更
     */
    @Test
    public void nft050StatusUpdate(){
        Nft050StatusUpdateReqDto reqDto = Nft050StatusUpdateReqDto.getNew();

        ZxlnftResponseDto<Nft050StatusUpdateRespDto> resp = zxlnftSdkUtil.nft050StatusUpdate(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 51 NFT销售状态变更查询
     */
    @Test
    public void nft051StatusUpdateResult(){
        Nft051StatusUpdateResultReqDto reqDto = Nft051StatusUpdateResultReqDto.getNew();

        ZxlnftResponseDto<Nft051StatusUpdateResultRespDto> resp = zxlnftSdkUtil.nft051StatusUpdateResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 52 NFT售价变更
     */
    @Test
    public void nft052PriceUpdate(){
        Nft052PriceUpdateReqDto reqDto = Nft052PriceUpdateReqDto.getNew();

        ZxlnftResponseDto<Nft052PriceUpdateRespDto> resp = zxlnftSdkUtil.nft052PriceUpdate(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 53 NFT售价变更状态查询
     */
    @Test
    public void nft053PriceUpdateResult(){
        Nft053PriceUpdateResultReqDto reqDto = Nft053PriceUpdateResultReqDto.getNew();
        reqDto.setPlatformPubKey("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        reqDto.setTaskId("8b7f328e-5a63-42f2-ad73-177d5157c4de_buy-nft-pay_1");
        ZxlnftResponseDto<Nft053PriceUpdateResultRespDto> resp = zxlnftSdkUtil.nft053PriceUpdateResult(reqDto);
        System.out.println(resp.toJson());
    }

    /**
     * 54 检查地址是否属于同一个用户主体接口
     */
    @Test
    public void nft054QueryUserAddressBelongToUser(){
        Nft054QueryUserAddressBelongToUserReqDto reqDto = Nft054QueryUserAddressBelongToUserReqDto.getNew();
        reqDto.setAddress1(zhouhuanAddress1);
        reqDto.setAddress2(zhouhuanAddress2);
        ZxlnftResponseDto<Nft054QueryUserAddressBelongToUserRespDto> resp = zxlnftSdkUtil.nft054QueryUserAddressBelongToUser(reqDto);
        System.out.println(resp.toJson());
//        返回结果
//        {"retCode":58,"retMsg":"NFT-验签错误","data":null}
    }
}
