package com.liquidnet.client.admin.web.controller.zhengzai.tools;

import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

@Controller
@RequestMapping("/tools")
public class ToolsBaseController extends BaseController {

    private String prefix = "zhengzai/tools";

    @GetMapping()
    public String tools() {
        return prefix + "/tools";
    }

    @GetMapping(value = "/details/{id}")
    public String detailsRoadShow(@PathVariable("id") Integer id, ModelMap mmap) {
        if (id == 1) {
            return prefix + "/fun1";
        } else {
            return prefix + "/edit";
        }
    }

    @PostMapping("/export/mobile")
    @ResponseBody
    public AjaxResult exportMobile(Integer mobileType) {
        System.out.println(mobileType);
        return toAjax(mobileType);
    }
}
