package com.liquidnet.service.kylin.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressRouteVo;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.IKylinOrderExpress;
import com.liquidnet.service.kylin.utils.DataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * <p>
 * 演出 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-05
 */
@Service
@Slf4j
public class PerformancesExpressInfoServiceImpl {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    HttpServletRequest httpServletRequest;

    @Autowired
    private DataUtils dataUtils;

    public KylinOrderExpressVo orderRouteDetail(String orderTicketsId) {
        List<KylinOrderExpressRouteVo> routeList = dataUtils.getOrderExpressRoute(orderTicketsId);
        KylinOrderExpressVo expressInfo = dataUtils.getOrderExpressInfos(orderTicketsId);
        expressInfo.setRouteList(routeList);
        return expressInfo;
    }
}