package com.liquidnet.service.adam.interceptor;

import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.common.web.filter.GlobalAuthorityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AdamAuthorityInterceptor extends GlobalAuthorityInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AdamAuthorityInterceptor.class);

    @Autowired
    RedisUtil redisUtil;

    @Override
    public String getAccessToken(String ssokey) {
        String val = null;
        try {
            val = (String) redisUtil.get(ssokey);
        } catch (Exception e) {
            log.error("ADAM:Authority Check Exception", e);
        }
        return val;
    }
}
