package com.liquidnet.service.platform.controller.candy.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.entity.CandyCoupon;
import com.liquidnet.service.candy.entity.CandyMgtCoupon;
import com.liquidnet.service.platform.service.impl.candy.PlatformCandyCouponService;
import com.liquidnet.service.platform.service.impl.candy.PlatformCandyMgtCouponService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("ccoupon/task/mgt")
public class CandyMgtCouponTaskController {
    @Autowired
    private PlatformCandyMgtCouponService platformCandyMgtCouponService;
    @Autowired
    private PlatformCandyCouponService platformCandyCouponService;

    @PutMapping("issue/coupons")
    public ResponseDto<String> issueCoupons() {
        LocalDateTime now = LocalDateTime.now();
        LambdaQueryWrapper<CandyMgtCoupon> queryWrapper = Wrappers.lambdaQuery(CandyMgtCoupon.class)
                .eq(CandyMgtCoupon::getState, 0)
                .le(CandyMgtCoupon::getEventAt, now)
                .orderByAsc(CandyMgtCoupon::getEventAt);
        List<CandyMgtCoupon> list = platformCandyMgtCouponService.list(queryWrapper);
        int taskSize = CollectionUtils.isEmpty(list) ? -1 : list.size(), pl = 0;
        log.info("发放券任务总数:{} >>> BEGIN BEGIN BEGIN", taskSize);

        for (int i = 0; i < taskSize; i++) {
            CandyMgtCoupon mgtCoupon = list.get(i);
            mgtCoupon.setState(9);
            mgtCoupon.setUpdatedAt(now);
        }
        if (platformCandyMgtCouponService.updateBatchById(list)) {
            for (int i = 0; i < taskSize; i++) {
                CandyMgtCoupon mgtCoupon = list.get(i);

                try {
                    LambdaQueryWrapper<CandyCoupon> couponLambdaQueryWrapper = Wrappers.lambdaQuery(CandyCoupon.class)
                            .eq(CandyCoupon::getState, 1).eq(CandyCoupon::getCouponId, mgtCoupon.getCouponId());
                    CandyCoupon coupon = platformCandyCouponService.getOne(couponLambdaQueryWrapper);

                    log.info("发放券任务总数:{},任务{}开始处理[mcouponId:{},couType:{},bindType:{},eventAmt:{},eventType:{}]", taskSize, i,
                            mgtCoupon.getMcouponId(), coupon.getCouType(), coupon.getBindType(), mgtCoupon.getEventAmt(), mgtCoupon.getEventType());

                    switch (coupon.getCouType()) {
                        case 1:// 代金券
                            platformCandyCouponService.issueCashCouponHandler(mgtCoupon, coupon);
                            break;
                        case 2:// 满减券
                            platformCandyCouponService.issueOverMinusCouponHandler(mgtCoupon, coupon);
                            break;
                        case 3:// 兑换券
                            platformCandyCouponService.issueExchangeCouponHandler(mgtCoupon, coupon);
                            break;
                        case 4:// 折扣券
                            platformCandyCouponService.issueDiscountCouponHandler(mgtCoupon, coupon);
                            break;
                        case 101:// 优先券
                            platformCandyCouponService.issuePriorityCouponHandler(mgtCoupon, coupon);
                            break;
                        default:
                            log.warn("发放券任务总数:{},任务{}无法处理，无效的券类型[mcouponId:{},couType:{}]", taskSize, i, mgtCoupon.getMcouponId(), coupon.getCouType());
                            break;
                    }

                    mgtCoupon.setState(1);
                    boolean update = platformCandyMgtCouponService.updateById(mgtCoupon);

                    log.info("发放券任务总数:{},任务{}处理{}[mcouponId:{},couType:{},bindType:{},eventAmt:{},eventType:{}]", taskSize, i, (update ? "成功" : "失败"),
                            mgtCoupon.getMcouponId(), coupon.getCouType(), coupon.getBindType(), mgtCoupon.getEventAmt(), mgtCoupon.getEventType());

                    pl++;
                } catch (Exception e) {
                    log.error("发放券任务总数:{},任务{}处理异常[mcouponId:{}]", taskSize, i, mgtCoupon.getMcouponId(), e);
                }
            }
        }
        log.info("发放券任务总数:{},成功处理任务数:{} >>> END END END", taskSize, pl);
        return ResponseDto.success(String.format("发放券任务总数:%s,成功处理任务数:%s", taskSize, pl));
    }
}
