package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.ZhengzaiAppVersionsListDao;
import com.liquidnet.service.kylin.dto.param.ZhengzaiAppVersionsParam;
import com.liquidnet.service.kylin.dto.param.admin.ZhengzaiAppVersionsSearchParam;
import com.liquidnet.service.kylin.dto.vo.admin.ZhengzaiAppVersionsVo;
import com.liquidnet.service.kylin.entity.KylinBanners;
import com.liquidnet.service.kylin.entity.KylinZhengzaiAppVersions;
import com.liquidnet.service.kylin.mapper.KylinBannersMapper;
import com.liquidnet.service.kylin.mapper.KylinZhengzaiAppVersionsMapper;
import com.liquidnet.service.kylin.service.admin.IKylinBannersService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 正在现场app版本控制 服务实现类
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-07-11
 */
@Service
public class KylinZhengzaiAppVersionsServiceImpl extends ServiceImpl<KylinBannersMapper, KylinBanners> implements IKylinBannersService {

    @Value("${liquidnet.al-oss.appUrl}")
    private String appUrl;

    @Autowired
    private KylinZhengzaiAppVersionsMapper kylinZhengzaiAppVersionsMapper;

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    public boolean create(ZhengzaiAppVersionsParam zhengzaiAppVersionsParam) {
        try {
            // 入数据库
            String zhengzaiAppVersionsId = IDGenerator.nextSnowId();
            zhengzaiAppVersionsParam.setZhengzaiAppVersionsId(zhengzaiAppVersionsId);
            zhengzaiAppVersionsParam.setCreatedAt(DateUtil.getNowTime());
            KylinZhengzaiAppVersions kylinZhengzaiAppVersions = new KylinZhengzaiAppVersions();
            BeanUtils.copyProperties(zhengzaiAppVersionsParam, kylinZhengzaiAppVersions);
            kylinZhengzaiAppVersionsMapper.insert(kylinZhengzaiAppVersions);
            getLastInfo();
            getLastInfoCheck();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public boolean update(ZhengzaiAppVersionsParam zhengzaiAppVersionsParam) {
        try {
            // 入数据库
            String zhengzaiAppVersionsId = zhengzaiAppVersionsParam.getZhengzaiAppVersionsId();
            zhengzaiAppVersionsParam.setUpdatedAt(DateUtil.getNowTime());
            KylinZhengzaiAppVersions kylinZhengzaiAppVersions = new KylinZhengzaiAppVersions();
            BeanUtils.copyProperties(zhengzaiAppVersionsParam, kylinZhengzaiAppVersions);
            kylinZhengzaiAppVersionsMapper.update(kylinZhengzaiAppVersions, new UpdateWrapper<KylinZhengzaiAppVersions>().eq("zhengzai_app_versions_id", zhengzaiAppVersionsId));
            getLastInfo();
            getLastInfoCheck();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public ZhengzaiAppVersionsVo detail(String zhengzaiAppVersionsId) {
        KylinZhengzaiAppVersions data = kylinZhengzaiAppVersionsMapper.selectOne(
                new UpdateWrapper<KylinZhengzaiAppVersions>().eq("zhengzai_app_versions_id", zhengzaiAppVersionsId).eq("is_deleted", 1)
        );
        ZhengzaiAppVersionsVo zhengzaiAppVersionsVo = new ZhengzaiAppVersionsVo();
        if (null != data) {
            BeanUtils.copyProperties(data, zhengzaiAppVersionsVo);
        } else {
            return null;
        }

        return zhengzaiAppVersionsVo;
    }

    public PageInfo<ZhengzaiAppVersionsListDao> listInfo(ZhengzaiAppVersionsSearchParam zhengzaiAppVersionsSearchParam) {
        try {
            PageHelper.startPage(zhengzaiAppVersionsSearchParam.getPageNum(), zhengzaiAppVersionsSearchParam.getPageSize());
            List<ZhengzaiAppVersionsListDao> voList = kylinZhengzaiAppVersionsMapper.searchList(BeanUtil.convertBeanToMap(zhengzaiAppVersionsSearchParam));
            for (ZhengzaiAppVersionsListDao item : voList) {
//                item.setCoverImg(imgUrl + item.getCoverImg());
            }
            return new PageInfo(voList);
        } catch (Exception e) {
            return new PageInfo(new ArrayList());
        }
    }

    public Boolean delete(List<String> zhengzaiAppVersionsIds) {
        try {
            KylinZhengzaiAppVersions kylinZhengzaiAppVersions = new KylinZhengzaiAppVersions();
            kylinZhengzaiAppVersions.setUpdatedAt(DateUtil.getNowTime());
            kylinZhengzaiAppVersions.setIsDeleted(2);
            kylinZhengzaiAppVersionsMapper.update(
                    kylinZhengzaiAppVersions
                    , new UpdateWrapper<KylinZhengzaiAppVersions>().in("zhengzai_app_versions_id", zhengzaiAppVersionsIds)
            );
            getLastInfo();
            getLastInfoCheck();
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public boolean getLastInfo() { // 因为有可能之前是ios 改成 android 如果单独处理一个会有问题 所以每次处理
        ZhengzaiAppVersionsListDao infoIos = kylinZhengzaiAppVersionsMapper.getLastInfo(1);
        ZhengzaiAppVersionsListDao infoAndroid = kylinZhengzaiAppVersionsMapper.getLastInfo(2);
        ZhengzaiAppVersionsVo zhengzaiAppVersionsVo = new ZhengzaiAppVersionsVo();
        redisDataSourceUtil.getRedisKylinUtil().del(KylinRedisConst.ZHENGZAI_APP_VERSIONS_IOS);
        if (null != infoIos) {
            BeanUtils.copyProperties(infoIos, zhengzaiAppVersionsVo);
            redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.ZHENGZAI_APP_VERSIONS_IOS, zhengzaiAppVersionsVo);
        }

        redisDataSourceUtil.getRedisKylinUtil().del(KylinRedisConst.ZHENGZAI_APP_VERSIONS_ANDROID);
        if (null != infoAndroid) {
            String newPath = appUrl + infoAndroid.getFilePath();
            infoAndroid.setFilePath(newPath);
            BeanUtils.copyProperties(infoAndroid, zhengzaiAppVersionsVo);
            redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.ZHENGZAI_APP_VERSIONS_ANDROID, zhengzaiAppVersionsVo);
        }

        return true;
    }

    public boolean getLastInfoCheck() { // 因为有可能之前是ios 改成 android 如果单独处理一个会有问题 所以每次处理
        ZhengzaiAppVersionsListDao infoIos = kylinZhengzaiAppVersionsMapper.getLastInfoCheck(1);
        ZhengzaiAppVersionsListDao infoAndroid = kylinZhengzaiAppVersionsMapper.getLastInfoCheck(2);
        ZhengzaiAppVersionsVo zhengzaiAppVersionsVo = new ZhengzaiAppVersionsVo();
        redisDataSourceUtil.getRedisKylinUtil().del(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_IOS);
        if (null != infoIos) {
            BeanUtils.copyProperties(infoIos, zhengzaiAppVersionsVo);
            redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_IOS, zhengzaiAppVersionsVo);
        }

        redisDataSourceUtil.getRedisKylinUtil().del(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_ANDROID);
        if (null != infoAndroid) {
            String newPath = appUrl + infoAndroid.getFilePath();
            infoAndroid.setFilePath(newPath);
            BeanUtils.copyProperties(infoAndroid, zhengzaiAppVersionsVo);
            redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.ZHENGZAI_APP_VERSIONS_CHECK_ANDROID, zhengzaiAppVersionsVo);
        }

        return true;
    }
}
