package com.liquidnet.service.merchant.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 公司表
 * </p>
 *
 * @author liquidnet
 * @since 2021-11-02
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MerchantCompanies implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * company_id
     */
    private String companyId;

    /**
     * 企业名称
     */
    private String name;

    /**
     * 营业执照编号
     */
    private String licenseCode;

    /**
     * 营业执照图片地址
     */
    private String licenseImg;

    /**
     * 法人姓名
     */
    private String legalName;

    /**
     * 法人身份证号码
     */
    private String legalIdentity;

    /**
     * 法人身份证正面照
     */
    private String legalIdentityObverse;

    /**
     * 法人身份证反面照
     */
    private String legalIdentityReverse;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
