package com.liquidnet.service.platform.service.impl.kylin;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.commons.lang.util.JsonUtils;

import com.liquidnet.service.kylin.constant.KylinRedisConst;
import com.liquidnet.service.kylin.dao.KylinFreightChargeDao;
import com.liquidnet.service.kylin.mapper.KylinFreightChargeMapper;
import com.liquidnet.service.platform.utils.ShunfengSignUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;



@Slf4j
@Service
public class KylinFreightChargeServiceImpl {
    @Autowired
    private ShunfengSignUtils shunfengSignUtils;

    @Autowired
    private RedisDataSourceUtil redisDataSourceUtil;
    @Autowired
    private KylinFreightChargeMapper kylinFreightChargeMapper;




    public void getFreightCharge() {
        Map<String, String> hBody = new HashMap<>();
        String jProvince="云南省";
        String jCity="昆明市";
        String jAddress="五华区";
        String addressCode= "530102";//区code

        hBody.put("jProvince", jProvince);
        hBody.put("jCity", jCity);
        hBody.put("jAddress", jAddress);
        hBody.put("dProvince", "北京市");
        hBody.put("dCity", "北京");
        hBody.put("dAddress", "东城区");
        String expressType = "1";
        hBody.put("expressType", "1");
        try {
            // 生成签名并请求
            String result = shunfengSignUtils.generateSignatureAndRequestNew(hBody, "/public/order/v1/getFreight");
            HashMap hashMap = JsonUtils.fromJson(result, HashMap.class);
            HashMap<String,String>  map = (HashMap<String, String>) hashMap.get("result");
            map.put("address",jProvince+":"+jCity+":"+jAddress);

            KylinFreightChargeDao kylinFreightCharge = KylinFreightChargeDao.getNew();
            kylinFreightCharge.setFieldsId(IDGenerator.nextTimeId2());
            kylinFreightCharge.setProvince(jProvince);
            kylinFreightCharge.setCity(jCity);
            kylinFreightCharge.setAdname(jAddress);
            kylinFreightCharge.setPrice(map.get("price"));
            kylinFreightCharge.setAdcode(addressCode);
            kylinFreightCharge.setBusinessType(map.get("businessType"));
            kylinFreightCharge.setBusinessTypeDesc(map.get("businessTypeDesc"));

            //存数据库
            int i= kylinFreightChargeMapper.setFreightCharge(kylinFreightCharge);
            //存redis
            redisDataSourceUtil.getRedisKylinUtil().set(KylinRedisConst.RETURN_ADDRESS_CODE+addressCode+KylinRedisConst.EXPRESS_TYPE+expressType,kylinFreightCharge);
        }catch (Exception e) {
            e.printStackTrace();
            log.error("顺丰接口调用失败", e);
        }
    }
}
