package com.liquidnet.commons.lang.util;

import com.google.zxing.*;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

/**
 * 二维码生成解析工具
 * Created with IntelliJ IDEA.
 * User: yupengfei
 * Date: 2016/10/18
 * Time: 11:20
 * To change this template use File | Settings | File Templates.
 */
public class QRCodeUtil {

    private  final static String IMG_PNG ="png";// 图像类型



    /**
     *根据内容获取图片byte[]
     * @param width 图像宽度
     * @param height 图像高度
     * @param content 文字内容
     * @return
     * @throws WriterException
     * @throws IOException
     */
    public static byte[] getByteFile(int width,int height,String content) throws WriterException, IOException {
        /*int width = 200; // 图像宽度
        int height = 200; // 图像高度*/
        Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content,
                BarcodeFormat.QR_CODE, width, height, hints);// 生成矩阵
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write(MatrixToImageWriter.toBufferedImage(bitMatrix),"png",out);
        return out.toByteArray();
    }

    /**
     *生成图像
     * @param width 图像宽度
     * @param height 图像高度
     * @param content 文字内容
     * @param filePath 存储路径
     * @throws WriterException
     * @throws IOException
     */
    public static void generateImg(int width,int height,String filePath,String content) throws WriterException, IOException {
        //String filePath = "D://";
        //String fileName = "zxing.png";
        //String content = "https://github.com/zxing/zxing/tree/zxing-3.0.0/javase/src/main/java/com/google/zxing";// 内容
        Map<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content,
                BarcodeFormat.QR_CODE, width, height, hints);// 生成矩阵
        Path path = FileSystems.getDefault().getPath(filePath);
        MatrixToImageWriter.writeToPath(bitMatrix, IMG_PNG, path);// 输出图像
    }

    /**
     * 解析图像
     */
    public static String analysis(String filePath) throws IOException, NotFoundException {
         BufferedImage image = ImageIO.read(new File(filePath));
        LuminanceSource source = new BufferedImageLuminanceSource(image);
        Binarizer binarizer = new HybridBinarizer(source);
        BinaryBitmap binaryBitmap = new BinaryBitmap(binarizer);
        Map<DecodeHintType, Object> hints = new HashMap<DecodeHintType, Object>();
        hints.put(DecodeHintType.CHARACTER_SET, "UTF-8");
        Result result = new MultiFormatReader().decode(binaryBitmap, hints);// 对图像进行解码
        return result.getText();
    }
}
