package com.liquidnet.service.adam.controller.admin;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.adam.dto.AdamMemberCodeParam;
import com.liquidnet.service.adam.dto.AdamMemberParam;
import com.liquidnet.service.adam.dto.vo.AdamMemberVo;
import com.liquidnet.service.adam.dto.vo.AdamUserInfoVo;
import com.liquidnet.service.adam.entity.AdamMember;
import com.liquidnet.service.adam.service.IAdamRdmService;
import com.liquidnet.service.adam.service.admin.IAdamMemberAdminService;
import com.liquidnet.service.adam.service.admin.IAdamMemberCodeAdminService;
import com.liquidnet.service.base.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.ArrayList;
import java.util.List;

@ApiSupport(order = 90060)
@Api(tags = "后台管理:会员信息")
@Slf4j
@Validated
@RestController
@RequestMapping("/admin/member")
public class AdamMemberAdminController extends AdamBaseController {
    @Autowired
    IAdamMemberAdminService adamMemberService;
    @Autowired
    IAdamMemberCodeAdminService adamMemberCodeAdminService;
    @Autowired
    IAdamRdmService adamRdmService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "添加会员卡")
    @PostMapping("add")
    public ResponseDto<Object> add(@RequestBody AdamMemberParam parameter) {
        return ResponseDto.success(adamMemberService.add(parameter));
    }

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "会员卡列表")
    @PostMapping("list")
    public ResponseDto<List<AdamMemberVo>> list() {
        List<AdamMember> list = adamMemberService.list();
        List<AdamMemberVo> vos = new ArrayList<>();
        list.forEach(r -> {
            vos.add(AdamMemberVo.getNew().copy(r));
        });
        return ResponseDto.success(vos);
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "同步会员卡")
    @PostMapping("sync")
    public ResponseDto<Object> sync() {
        return adamMemberService.sync();
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "生成兑换码")
    @PostMapping("gen_code")
    public ResponseDto<String> genMemberCode(@RequestBody AdamMemberCodeParam parameter) {
        return ResponseDto.success(adamMemberCodeAdminService.createGiftCode(parameter));
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "会员黑名单UID")
    @PostMapping("blk/lis")
    public ResponseDto<List<String>> listBlack() {
        return ResponseDto.success(adamRdmService.getBlacklistForMember());
    }

    @ApiOperationSupport(order = 6)
    @ApiOperation(value = "添加会员黑名单")
    @PostMapping("blk/add")
    public ResponseDto<List<String>> addBlack(@NotBlank @RequestParam String opts) {
        String[] uidArr = opts.split(",");
        List<String> invalidList = new ArrayList<>(), existList = new ArrayList<>();
        for (String uid : uidArr) {
            AdamUserInfoVo vo = adamRdmService.getUserInfoVoByUid(uid);
            if (null != vo) {
                existList.add(uid);
            } else {
                invalidList.add(uid);
            }
        }
        List<String> blacklist = adamRdmService.getBlacklistForMember();
        if (CollectionUtils.isEmpty(blacklist)) {
            blacklist = existList;
        } else {
            blacklist.addAll(existList);
        }
        if (!CollectionUtils.isEmpty(blacklist)) {
            adamRdmService.setBlacklistForMember(blacklist);
        } else {
            log.warn("###blacklist.add:failed,invalidList:{},existList:{},opts:{}", invalidList.size(), existList.size(), opts);
        }
        return ResponseDto.success(invalidList);
    }

    @ApiOperationSupport(order = 7)
    @ApiOperation(value = "删除会员黑名单")
    @PostMapping("blk/del")
    public ResponseDto<Object> delBlack(@NotBlank @RequestParam String opts) {
        String[] uidArr = opts.split(",");
        List<String> blacklist = adamRdmService.getBlacklistForMember();
        if (!CollectionUtils.isEmpty(blacklist)) {
            for (String uid : uidArr) {
                blacklist.remove(uid);
            }
            adamRdmService.setBlacklistForMember(blacklist);
        }
        return ResponseDto.success();
    }
}
