package com.liquidnet.service.kylin.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 快递表
 * </p>
 *
 * @author liquidnet
 * @since 2021-05-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class Expresses implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 管理员
     */
    private Integer adminId;

    /**
     * 订单Id
     */
    private Integer orderId;

    /**
     * 订单编号
     */
    private String orderCode;

    /**
     * 订单类型 order_product 商品订单 , order_ticket 票务订单, order_integration 积分订单
     */
    private String orderType;

    /**
     * 状态 -1待揽收、0在途中、1已揽收、2疑难、3已签收
     */
    private Integer status;

    /**
     * 快递单号
     */
    private String number;

    /**
     * 快递公司名称
     */
    private String name;

    /**
     * 快递公司编号
     */
    private String company;

    private LocalDateTime createdAt;

    private LocalDateTime updatedAt;


}
