package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SaleDataVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmilePriceParam;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

/**
 * @author TT
 */
@Api(tags = "演出管理")
@Controller
@RequestMapping("/smile/show/base")
public class SmileShowBaseController extends BaseController {

    private String prefix = "zhengzai/smile";

    @Autowired
    ISmileShowService smileShowService;

    @GetMapping("/saleData/{performancesId}")
    @ApiOperation("销售数据")
    public String saleData(@PathVariable("performancesId") String performancesId, ModelMap mmap) {
        SaleDataVo saleDataVo = smileShowService.saleData(performancesId);
        mmap.put("saleDataVo", saleDataVo);
        return prefix + "/smileTickets/saleData";
    }

}
